/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.scanner.csv;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.dataset.file.FileFormat;
import org.apache.arrow.dataset.scanner.FragmentScanOptions;
import org.apache.arrow.dataset.scanner.csv.CsvConvertOptions;
import org.apache.arrow.dataset.utils.MapUtil;

public class CsvFragmentScanOptions
implements FragmentScanOptions {
    private final CsvConvertOptions convertOptions;
    private final Map<String, String> readOptions;
    private final Map<String, String> parseOptions;

    public CsvFragmentScanOptions(CsvConvertOptions convertOptions, Map<String, String> readOptions, Map<String, String> parseOptions) {
        this.convertOptions = convertOptions;
        this.readOptions = readOptions;
        this.parseOptions = parseOptions;
    }

    @Override
    public FileFormat fileFormat() {
        return FileFormat.CSV;
    }

    @Override
    public String[] serialize() {
        Map<String, String> options = Stream.concat(Stream.concat(this.readOptions.entrySet().stream(), this.parseOptions.entrySet().stream()), this.convertOptions.getConfigs().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.convertOptions.getArrowSchema().isPresent()) {
            options.put("column_types", Long.toString(this.convertOptions.getArrowSchema().get().memoryAddress()));
        }
        return MapUtil.convertMapToStringArray(options);
    }

    public CsvConvertOptions getConvertOptions() {
        return this.convertOptions;
    }

    public Map<String, String> getReadOptions() {
        return this.readOptions;
    }

    public Map<String, String> getParseOptions() {
        return this.parseOptions;
    }
}

