/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util.hash;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;

public class MurmurHasher
implements ArrowBufHasher {
    private final int seed;

    public MurmurHasher() {
        this(0);
    }

    public MurmurHasher(int seed) {
        this.seed = seed;
    }

    @Override
    public int hashCode(long address, int length) {
        return MurmurHasher.hashCode(address, length, this.seed);
    }

    @Override
    public int hashCode(ArrowBuf buf, int offset, int length) {
        buf.checkBytes(offset, offset + length);
        return this.hashCode(buf.memoryAddress() + (long)offset, length);
    }

    public static int hashCode(ArrowBuf buf, int offset, int length, int seed) {
        buf.checkBytes(offset, offset + length);
        return MurmurHasher.hashCode(buf.memoryAddress() + (long)offset, length, seed);
    }

    public static int hashCode(long address, int length, int seed) {
        int intValue;
        int index = 0;
        int hash = seed;
        while (index + 4 <= length) {
            intValue = PlatformDependent.getInt((long)(address + (long)index));
            hash = MurmurHasher.combineHashCode(hash, intValue);
            index += 4;
        }
        if (index < length) {
            intValue = 0;
            for (int i = index - 1; i >= index; ++index, --i) {
                intValue <<= 8;
                intValue |= PlatformDependent.getByte((long)(address + (long)i)) & 0xFF;
            }
            hash = MurmurHasher.combineHashCode(hash, intValue);
        }
        return MurmurHasher.finalizeHashCode(hash, length);
    }

    public static int combineHashCode(int currentHashCode, int intValue) {
        int c1 = -862048943;
        int c2 = 461845907;
        int r1 = 15;
        int r2 = 13;
        int m = 5;
        int n = -430675100;
        int k = intValue;
        k *= c1;
        k = MurmurHasher.rotateLeft(k, r1);
        int hash = currentHashCode;
        hash ^= (k *= c2);
        hash = MurmurHasher.rotateLeft(hash, r2);
        hash = hash * m + n;
        return hash;
    }

    public static int finalizeHashCode(int hashCode, int length) {
        hashCode ^= length;
        hashCode ^= hashCode >>> 16;
        hashCode *= -2048144789;
        hashCode ^= hashCode >>> 13;
        hashCode *= -1028477387;
        hashCode ^= hashCode >>> 16;
        return hashCode;
    }

    private static int rotateLeft(int value, int count) {
        return value << count | value >>> 32 - count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MurmurHasher that = (MurmurHasher)o;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return this.seed;
    }
}

