/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLEndpoint {
    private Pattern urlPattern;
    private Map<String, Builder> messageBuilders = new HashMap<String, Builder>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Builder defaultBuilder = new SOAPBuilder();

    public URLEndpoint(Pattern urlPattern) {
        this.urlPattern = urlPattern;
    }

    public boolean isMatching(String url) {
        Matcher matcher = this.urlPattern.matcher(url);
        return matcher.matches();
    }

    public void addBuilder(String name, Builder builder) {
        this.messageBuilders.put(name, builder);
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public Parameter getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setDefaultBuilder(Builder defaultBuilder) {
        this.defaultBuilder = defaultBuilder;
    }

    public Builder getBuilder(String contentType) {
        Builder builder = this.messageBuilders.get(contentType);
        if (builder == null) {
            return this.defaultBuilder;
        }
        return builder;
    }

    public void setParameters(MessageContext msgCtx) {
        for (Parameter p : this.parameters) {
            msgCtx.setProperty(p.getName(), p.getValue());
        }
    }
}

