/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.helper;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.tools.apt.helper.CollectionStringBuffer;
import org.apache.camel.tools.apt.helper.Strings;
import org.json.simple.JsonObject;
import org.json.simple.Jsoner;

public final class JsonSchemaHelper {
    private static final String VALID_CHARS = ".-='/\\!&():;";

    private JsonSchemaHelper() {
    }

    public static String toJson(String name, String displayName, String kind, Boolean required, String type, String defaultValue, String description, Boolean deprecated, String deprecationNote, Boolean secret, String group, String label, boolean enumType, Set<String> enums, boolean oneOfType, Set<String> oneOffTypes, boolean asPredicate, String optionalPrefix, String prefix, boolean multiValue) {
        boolean predicate;
        String text;
        String typeName = JsonSchemaHelper.getType(type, enumType);
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.doubleQuote(name));
        sb.append(": { \"kind\": ");
        sb.append(Strings.doubleQuote(kind));
        if (Strings.isNullOrEmpty(displayName)) {
            displayName = Strings.asTitle(name);
        }
        sb.append(", \"displayName\": ");
        sb.append(Strings.doubleQuote(displayName));
        if (!Strings.isNullOrEmpty(group)) {
            sb.append(", \"group\": ");
            sb.append(Strings.doubleQuote(group));
        }
        if (!Strings.isNullOrEmpty(label)) {
            sb.append(", \"label\": ");
            sb.append(Strings.doubleQuote(label));
        }
        if (required != null) {
            sb.append(", \"required\": ");
            sb.append(required.toString());
        }
        sb.append(", \"type\": ");
        if ("enum".equals(typeName)) {
            String actualType = JsonSchemaHelper.getType(type, false);
            sb.append(Strings.doubleQuote(actualType));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer enumValues = new CollectionStringBuffer();
            for (String value : enums) {
                enumValues.append(Strings.doubleQuote(value.toString()));
            }
            sb.append(", \"enum\": [ ");
            sb.append(enumValues.toString());
            sb.append(" ]");
        } else if (oneOfType) {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer oneOfValues = new CollectionStringBuffer();
            for (Object e : oneOffTypes) {
                oneOfValues.append(Strings.doubleQuote(e.toString()));
            }
            sb.append(", \"oneOf\": [ ");
            sb.append(oneOfValues.toString());
            sb.append(" ]");
        } else if ("array".equals(typeName)) {
            sb.append(Strings.doubleQuote("array"));
            sb.append(", \"javaType\": \"" + type + "\"");
        } else {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
        }
        if (!Strings.isNullOrEmpty(optionalPrefix)) {
            sb.append(", \"optionalPrefix\": ");
            text = JsonSchemaHelper.safeDefaultValue(optionalPrefix);
            sb.append(Strings.doubleQuote(text));
        }
        if (!Strings.isNullOrEmpty(prefix)) {
            sb.append(", \"prefix\": ");
            text = JsonSchemaHelper.safeDefaultValue(prefix);
            sb.append(Strings.doubleQuote(text));
        }
        if (multiValue) {
            sb.append(", \"multiValue\": true");
        }
        if (deprecated != null) {
            sb.append(", \"deprecated\": ");
            sb.append(deprecated.toString());
        }
        if (!Strings.isNullOrEmpty(deprecationNote)) {
            sb.append(", \"deprecationNote\": ");
            sb.append(Strings.doubleQuote(deprecationNote));
        }
        if (secret != null) {
            sb.append(", \"secret\": ");
            sb.append(secret.toString());
        }
        if (!Strings.isNullOrEmpty(defaultValue)) {
            sb.append(", \"defaultValue\": ");
            text = JsonSchemaHelper.safeDefaultValue(defaultValue);
            if ("boolean".equals(typeName) || "integer".equals(typeName) || "number".equals(typeName)) {
                sb.append(text);
            } else {
                sb.append(Strings.doubleQuote(text));
            }
        }
        boolean bl = predicate = "expression".equals(kind) || asPredicate;
        if (predicate) {
            sb.append(", \"asPredicate\": ");
            if (asPredicate) {
                sb.append("true");
            } else {
                sb.append("false");
            }
        }
        if (!Strings.isNullOrEmpty(description)) {
            sb.append(", \"description\": ");
            String text2 = JsonSchemaHelper.sanitizeDescription(description, false);
            sb.append(Strings.doubleQuote(text2));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String getType(String type, boolean enumType) {
        if (enumType) {
            return "enum";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.equals(File.class.getName())) {
            return "string";
        }
        if (type.equals(Date.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static String sanitizeDescription(String javadoc, boolean summary) {
        if (Strings.isNullOrEmpty(javadoc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = javadoc.split("\n");
        boolean first = true;
        for (String line : lines) {
            boolean haveText;
            if ((line = line.trim()).startsWith("@param") || line.startsWith("@return") || line.startsWith("@deprecated")) break;
            if (line.startsWith("@")) continue;
            line = line.replaceAll("<.*?>", "");
            line = line.replaceAll("\\{\\@\\w+\\s([\\w.]+)\\}", "$1");
            if (!first) {
                sb.append(' ');
            }
            StringBuilder cb = new StringBuilder();
            for (char c : line.toCharArray()) {
                if (Character.isJavaIdentifierPart(c) || VALID_CHARS.indexOf(c) != -1) {
                    cb.append(c);
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                cb.append(' ');
            }
            String s = cb.toString().trim();
            sb.append(s);
            boolean empty = Strings.isNullOrEmpty(s);
            boolean endWithDot = s.endsWith(".");
            boolean bl = haveText = sb.length() > 0;
            if (haveText && summary && (empty || endWithDot)) break;
            first = false;
        }
        String s = sb.toString();
        s = s.replaceAll("\\s+", " ");
        return s.trim();
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        try {
            JsonObject output = (JsonObject)Jsoner.deserialize((String)json);
            for (String key : output.keySet()) {
                Map row = output.getMap(key);
                if (!key.equals(group)) continue;
                if (parseProperties) {
                    Iterator iterator = row.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry entry = obj = iterator.next();
                        LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                        newRow.put("name", entry.getKey().toString());
                        Map<String, String> newData = JsonSchemaHelper.transformMap((Map)entry.getValue());
                        newRow.putAll(newData);
                        answer.add(newRow);
                    }
                    continue;
                }
                Map<String, String> newData = JsonSchemaHelper.transformMap(row);
                Iterator<Map.Entry<String, String>> iterator = newData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                    newRow.put(entry.getKey().toString(), entry.getValue().toString());
                    answer.add(newRow);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
        return answer;
    }

    private static Map<String, String> transformMap(Map jsonMap) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry rowObj : jsonMap.entrySet()) {
            Map.Entry rowEntry = rowObj;
            Object newValue = rowEntry.getValue();
            if (newValue instanceof List) {
                List list = (List)newValue;
                CollectionStringBuffer csb = new CollectionStringBuffer(",");
                for (Object line : list) {
                    csb.append(line);
                }
                newValue = csb.toString();
            }
            String value = JsonSchemaHelper.escapeJson(newValue.toString());
            answer.put(rowEntry.getKey().toString(), value);
        }
        return answer;
    }

    private static String escapeJson(String value) {
        return value.replaceAll("\\\\r", "\\\\\\r").replaceAll("\\\\n", "\\\\\\n").replaceAll("\\\\t", "\\\\\\t");
    }

    private static String safeDefaultValue(String value) {
        if ("\"".equals(value)) {
            return "\\\"";
        }
        if ("\\".equals(value)) {
            return "\\\\";
        }
        return value;
    }
}

