/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

public class InvalidAS2NameException
extends Exception {
    private static final long serialVersionUID = -6284079291785073089L;
    private final String name;
    private final int index;

    public InvalidAS2NameException(String name, int index) {
        this.name = name;
        this.index = index;
    }

    @Override
    public String getMessage() {
        char character = this.name.charAt(this.index);
        String invalidChar = "" + character;
        if (Character.isISOControl(character)) {
            invalidChar = String.format("\\u%04x", character);
        }
        return "Invalid character '" + invalidChar + "' at index " + this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }
}

