/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponentVerifierExtension;
import org.apache.camel.component.aws.firehose.KinesisFirehoseConfiguration;
import org.apache.camel.component.aws.firehose.KinesisFirehoseEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws-kinesis-firehose")
public class KinesisFirehoseComponent
extends DefaultComponent {
    @Metadata
    private KinesisFirehoseConfiguration configuration = new KinesisFirehoseConfiguration();

    public KinesisFirehoseComponent() {
        this(null);
    }

    public KinesisFirehoseComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisFirehoseComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisFirehoseConfiguration configuration = this.configuration != null ? this.configuration.copy() : new KinesisFirehoseConfiguration();
        configuration.setStreamName(remaining);
        KinesisFirehoseEndpoint endpoint = new KinesisFirehoseEndpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonKinesisFirehoseClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonKinesisFirehoseClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KinesisFirehoseConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisFirehoseConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(KinesisFirehoseConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonKinesisFirehose.class);
        if (clients.size() == 1) {
            configuration.setAmazonKinesisFirehoseClient((AmazonKinesisFirehose)clients.stream().findFirst().get());
        }
    }
}

