/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class DescribeTableCommand
extends AbstractDdbCommand {
    public DescribeTableCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        DescribeTableResult result = this.ddbClient.describeTable(new DescribeTableRequest().withTableName(this.determineTableName()));
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsDdbTableName", (Object)result.getTable().getTableName());
        msg.setHeader("CamelAwsDdbTableStatus", (Object)result.getTable().getTableStatus());
        msg.setHeader("CamelAwsDdbCreationDate", (Object)result.getTable().getCreationDateTime());
        msg.setHeader("CamelAwsDdbTableItemCount", (Object)result.getTable().getItemCount());
        msg.setHeader("CamelAwsDdbKeySchema", (Object)result.getTable().getKeySchema());
        msg.setHeader("CamelAwsDdbReadCapacity", (Object)result.getTable().getProvisionedThroughput().getReadCapacityUnits());
        msg.setHeader("CamelAwsDdbWriteCapacity", (Object)result.getTable().getProvisionedThroughput().getWriteCapacityUnits());
        msg.setHeader("CamelAwsDdbTableSize", (Object)result.getTable().getTableSizeBytes());
    }
}

