/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.Record;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;
import org.apache.camel.component.aws.ddbstream.DdbStreamConsumer;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.17.0", scheme="aws-ddbstream", title="AWS DynamoDB Streams", consumerOnly=true, syntax="aws-ddbstream:tableName", consumerClass=DdbStreamConsumer.class, label="cloud,messaging,streams")
public class DdbStreamEndpoint
extends ScheduledPollEndpoint {
    @UriPath(label="consumer", description="Name of the dynamodb table")
    @Metadata(required="true")
    private String tableName;
    @UriParam(label="consumer", description="Amazon DynamoDB client to use for all requests for this endpoint")
    @Metadata(required="true")
    private AmazonDynamoDBStreams amazonDynamoDbStreamsClient;
    @UriParam(label="consumer", description="Maximum number of records that will be fetched in each poll")
    private int maxResultsPerRequest = 100;
    @UriParam(label="consumer", description="Defines where in the DynaboDB stream to start getting records. Note that using TRIM_HORIZON can cause a significant delay before the stream has caught up to real-time. if {AT,AFTER}_SEQUENCE_NUMBER are used, then a sequenceNumberProvider MUST be supplied.", defaultValue="LATEST")
    private ShardIteratorType iteratorType = ShardIteratorType.LATEST;
    @UriParam(label="consumer", description="Provider for the sequence number when using one of the two ShardIteratorType.{AT,AFTER}_SEQUENCE_NUMBER iterator types. Can be a registry reference or a literal sequence number.")
    private SequenceNumberProvider sequenceNumberProvider;

    public DdbStreamEndpoint(String uri, String tableName, DdbStreamComponent component) {
        super(uri, (Component)component);
        this.tableName = tableName;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DdbStreamConsumer consumer = new DdbStreamConsumer(this, processor);
        consumer.setSchedulerProperties(consumer.getEndpoint().getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    Exchange createExchange(Record record) {
        Exchange ex = super.createExchange();
        ex.getIn().setBody((Object)record, Record.class);
        return ex;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getSequenceNumber() {
        switch (this.getIteratorType()) {
            case AFTER_SEQUENCE_NUMBER: 
            case AT_SEQUENCE_NUMBER: {
                if (null == this.getSequenceNumberProvider()) {
                    throw new IllegalStateException("sequenceNumberProvider must be provided, either as an implementation of SequenceNumberProvider or a literal String.");
                }
                return this.getSequenceNumberProvider().getSequenceNumber();
            }
        }
        return "";
    }

    public String toString() {
        return "DdbStreamEndpoint{tableName=" + this.tableName + ", amazonDynamoDbStreamsClient=[redacted], maxResultsPerRequest=" + this.maxResultsPerRequest + ", iteratorType=" + this.iteratorType + ", sequenceNumberProvider=" + this.sequenceNumberProvider + ", uri=" + this.getEndpointUri() + '}';
    }

    AmazonDynamoDBStreams getClient() {
        return this.amazonDynamoDbStreamsClient;
    }

    public AmazonDynamoDBStreams getAmazonDynamoDBStreamsClient() {
        return this.amazonDynamoDbStreamsClient;
    }

    public void setAmazonDynamoDbStreamsClient(AmazonDynamoDBStreams amazonDynamoDbStreamsClient) {
        this.amazonDynamoDbStreamsClient = amazonDynamoDbStreamsClient;
    }

    public int getMaxResultsPerRequest() {
        return this.maxResultsPerRequest;
    }

    public void setMaxResultsPerRequest(int maxResultsPerRequest) {
        this.maxResultsPerRequest = maxResultsPerRequest;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ShardIteratorType getIteratorType() {
        return this.iteratorType;
    }

    public void setIteratorType(ShardIteratorType iteratorType) {
        this.iteratorType = iteratorType;
    }

    public SequenceNumberProvider getSequenceNumberProvider() {
        return this.sequenceNumberProvider;
    }

    public void setSequenceNumberProvider(SequenceNumberProvider sequenceNumberProvider) {
        this.sequenceNumberProvider = sequenceNumberProvider;
    }
}

