/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.apache.camel.component.aws.lambda.LambdaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.20.0", scheme="aws-lambda", title="AWS Lambda", syntax="aws-lambda:function", producerOnly=true, label="cloud,computing,serverless")
public class LambdaEndpoint
extends DefaultEndpoint {
    private AWSLambda awsLambdaClient;
    @UriParam
    private LambdaConfiguration configuration;

    public LambdaEndpoint(String uri, Component component, LambdaConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new LambdaProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsLambdaClient = this.configuration.getAwsLambdaClient() != null ? this.configuration.getAwsLambdaClient() : this.createLambdaClient();
    }

    public LambdaConfiguration getConfiguration() {
        return this.configuration;
    }

    public AWSLambda getAwsLambdaClient() {
        return this.awsLambdaClient;
    }

    AWSLambda createLambdaClient() {
        AWSLambdaClientBuilder builder = AWSLambdaClientBuilder.standard();
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            builder = (AWSLambdaClientBuilder)builder.withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAwsLambdaEndpoint())) {
            builder = (AWSLambdaClientBuilder)builder.withRegion(this.configuration.getAwsLambdaEndpoint());
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            builder = (AWSLambdaClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
        }
        return (AWSLambda)builder.build();
    }
}

