/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class BatchDeleteAttributesCommand
extends AbstractSdbCommand {
    public BatchDeleteAttributesCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        BatchDeleteAttributesRequest request = new BatchDeleteAttributesRequest().withDomainName(this.determineDomainName()).withItems(this.determineDeletableItems());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        this.sdbClient.batchDeleteAttributes(request);
        this.log.trace("Request sent");
    }

    protected Collection<DeletableItem> determineDeletableItems() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsSdbDeletableItems", Collection.class);
    }
}

