/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.NoSuchDomainException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.apache.camel.component.aws.sdb.SdbProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.9.0", scheme="aws-sdb", title="AWS SimpleDB", syntax="aws-sdb:domainName", producerOnly=true, label="cloud,database,nosql")
public class SdbEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(S3Endpoint.class);
    private AmazonSimpleDB sdbClient;
    @UriParam
    private SdbConfiguration configuration;

    @Deprecated
    public SdbEndpoint(String uri, CamelContext context, SdbConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public SdbEndpoint(String uri, Component component, SdbConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SdbProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.sdbClient = this.configuration.getAmazonSDBClient() != null ? this.configuration.getAmazonSDBClient() : this.createSdbClient();
        String domainName = this.getConfiguration().getDomainName();
        LOG.trace("Querying whether domain [{}] already exists...", (Object)domainName);
        try {
            this.sdbClient.domainMetadata(new DomainMetadataRequest(domainName));
            LOG.trace("Domain [{}] already exists", (Object)domainName);
            return;
        }
        catch (NoSuchDomainException ase) {
            LOG.trace("Domain [{}] doesn't exist yet", (Object)domainName);
            LOG.trace("Creating domain [{}]...", (Object)domainName);
            this.sdbClient.createDomain(new CreateDomainRequest(domainName));
            LOG.trace("Domain [{}] created", (Object)domainName);
            return;
        }
    }

    public SdbConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonSimpleDB getSdbClient() {
        return this.sdbClient;
    }

    AmazonSimpleDB createSdbClient() {
        AmazonSimpleDB client = null;
        AmazonSimpleDBClientBuilder clientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonSimpleDBClientBuilder)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonSimpleDBClientBuilder.standard() : (AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonSdbEndpoint()) && ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.configuration.getAmazonSdbEndpoint(), this.configuration.getRegion());
            clientBuilder = (AmazonSimpleDBClientBuilder)clientBuilder.withEndpointConfiguration(endpointConfiguration);
        }
        client = (AmazonSimpleDB)clientBuilder.build();
        return client;
    }
}

