/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.Topic;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsHeaderFilterStrategy;
import org.apache.camel.component.aws.sns.SnsProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.8.0", scheme="aws-sns", title="AWS Simple Notification System", syntax="aws-sns:topicNameOrArn", producerOnly=true, label="cloud,mobile,messaging")
public class SnsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(SnsEndpoint.class);
    private AmazonSNS snsClient;
    @UriPath(description="Topic name or ARN")
    @Metadata(required="true")
    private String topicNameOrArn;
    @UriParam
    private SnsConfiguration configuration;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    @Deprecated
    public SnsEndpoint(String uri, CamelContext context, SnsConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public SnsEndpoint(String uri, Component component, SnsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SnsProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        AmazonSNS amazonSNS = this.snsClient = this.configuration.getAmazonSNSClient() != null ? this.configuration.getAmazonSNSClient() : this.createSNSClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SnsHeaderFilterStrategy();
        }
        if (this.configuration.getTopicArn() == null) {
            try {
                String nextToken = null;
                String arnSuffix = ":" + this.configuration.getTopicName();
                block2: do {
                    ListTopicsResult response = this.snsClient.listTopics(nextToken);
                    nextToken = response.getNextToken();
                    for (Topic topic : response.getTopics()) {
                        if (!topic.getTopicArn().endsWith(arnSuffix)) continue;
                        this.configuration.setTopicArn(topic.getTopicArn());
                        continue block2;
                    }
                } while (nextToken != null);
            }
            catch (AmazonServiceException ase) {
                LOG.trace("The list topics operation return the following error code {}", (Object)ase.getErrorCode());
                throw ase;
            }
        }
        if (this.configuration.getTopicArn() == null) {
            CreateTopicRequest request = new CreateTopicRequest(this.configuration.getTopicName());
            LOG.trace("Creating topic [{}] with request [{}]...", (Object)this.configuration.getTopicName(), (Object)request);
            CreateTopicResult result = this.snsClient.createTopic(request);
            this.configuration.setTopicArn(result.getTopicArn());
            LOG.trace("Topic created with Amazon resource name: {}", (Object)this.configuration.getTopicArn());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getPolicy())) {
            LOG.trace("Updating topic [{}] with policy [{}]", (Object)this.configuration.getTopicArn(), (Object)this.configuration.getPolicy());
            this.snsClient.setTopicAttributes(new SetTopicAttributesRequest(this.configuration.getTopicArn(), "Policy", this.configuration.getPolicy()));
            LOG.trace("Topic policy updated");
        }
    }

    public SnsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SnsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setSNSClient(AmazonSNS snsClient) {
        this.snsClient = snsClient;
    }

    public AmazonSNS getSNSClient() {
        return this.snsClient;
    }

    AmazonSNS createSNSClient() {
        AmazonSNS client = null;
        AmazonSNSClientBuilder clientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonSNSClientBuilder.standard() : (AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonSNSEndpoint()) && ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.configuration.getAmazonSNSEndpoint(), this.configuration.getRegion());
            clientBuilder = (AmazonSNSClientBuilder)clientBuilder.withEndpointConfiguration(endpointConfiguration);
        }
        client = (AmazonSNS)clientBuilder.build();
        return client;
    }
}

