/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.util.List;
import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanExpressionProcessor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.component.bean.RequestBeanHolder;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class BeanExpression
implements Expression,
Predicate {
    private ParameterMappingStrategy parameterMappingStrategy;
    private BeanComponent beanComponent;
    private Language simple;
    private Class<?> resultType;
    private final Object bean;
    private String beanName;
    private Class<?> type;
    private final String method;
    private BeanHolder beanHolder;
    private boolean ognlMethod;
    private BeanScope scope = BeanScope.Singleton;
    private boolean validate = true;

    public BeanExpression(Object bean, String method) {
        this.bean = bean;
        this.method = method;
        this.beanName = null;
        this.type = null;
    }

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
        this.bean = null;
        this.type = null;
    }

    public BeanExpression(Class<?> type, String method) {
        this.type = type;
        this.method = method;
        this.bean = null;
        this.beanName = null;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public ParameterMappingStrategy getParameterMappingStrategy() {
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    public BeanComponent getBeanComponent() {
        return this.beanComponent;
    }

    public void setBeanComponent(BeanComponent beanComponent) {
        this.beanComponent = beanComponent;
    }

    public Language getSimple() {
        return this.simple;
    }

    public void setSimple(Language simple) {
        this.simple = simple;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public void init(CamelContext context) {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = ParameterMappingStrategyHelper.createParameterMappingStrategy(context);
        }
        if (this.beanComponent == null) {
            this.beanComponent = (BeanComponent)context.getComponent("bean", BeanComponent.class);
        }
        if (this.beanName != null && this.beanName.startsWith("type:")) {
            String fqn = this.beanName.substring(5);
            try {
                this.type = context.getClassResolver().resolveMandatoryClass(fqn);
                this.beanName = null;
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchBeanException(this.beanName, (Throwable)e);
            }
        }
        if (this.beanHolder == null) {
            this.beanHolder = this.createBeanHolder(context, this.parameterMappingStrategy, this.beanComponent);
        }
        Object target = this.beanHolder.getBean(null);
        if (this.method != null) {
            if (this.validate) {
                this.validateHasMethod(context, target, this.type, this.method);
                if (OgnlHelper.isInvalidValidOgnlExpression((String)this.method)) {
                    throw new ExpressionIllegalSyntaxException(this.method);
                }
            }
            this.ognlMethod = OgnlHelper.isValidOgnlExpression((String)this.method);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("BeanExpression[");
        if (this.bean != null) {
            sb.append(this.bean);
        } else if (this.beanName != null) {
            sb.append(this.beanName);
        } else if (this.type != null) {
            sb.append(ObjectHelper.className(this.type));
        }
        if (this.method != null) {
            sb.append(" method:").append(this.method);
        }
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        if (this.beanHolder == null) {
            throw new IllegalStateException("The expression must be initialized first");
        }
        try {
            if (this.ognlMethod) {
                return this.invokeOgnlMethod(this.beanHolder, this.beanName, this.method, exchange);
            }
            return BeanExpression.invokeBean(this.beanHolder, this.beanName, this.method, exchange);
        }
        catch (RuntimeBeanExpressionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeBeanExpressionException(exchange, BeanExpression.getBeanName(exchange, this.beanName, this.beanHolder), this.method, e);
        }
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        if (Object.class == type) {
            return (T)(this.resultType == null ? result : exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, result));
        }
        return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, result);
    }

    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange);
        return ObjectHelper.evaluateValuePredicate((Object)value);
    }

    protected void validateHasMethod(CamelContext context, Object bean, Class<?> type, String method) {
        if (method == null) {
            return;
        }
        if (bean == null && type == null) {
            throw new IllegalArgumentException("Either bean or type should be provided on " + String.valueOf(this));
        }
        if (OgnlHelper.isValidOgnlExpression((String)method)) {
            return;
        }
        if (bean == null && ObjectHelper.hasDefaultPublicNoArgConstructor(type)) {
            bean = context.getInjector().newInstance(type);
        }
        if (OgnlHelper.isInvalidValidOgnlExpression((String)method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(method);
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException((Object)(bean != null ? bean : type), method, (Throwable)cause)));
        }
        if (bean != null) {
            BeanInfo info = new BeanInfo(context, bean.getClass(), this.parameterMappingStrategy, this.beanComponent);
            if (!info.hasMethod(method)) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, bean, method)));
            }
        } else {
            BeanInfo info = new BeanInfo(context, type, this.parameterMappingStrategy, this.beanComponent);
            if (!info.hasStaticMethod(method)) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, type, method, true)));
            }
        }
    }

    private BeanHolder createBeanHolder(CamelContext context, ParameterMappingStrategy parameterMappingStrategy, BeanComponent beanComponent) {
        BeanHolder holder = null;
        if (this.bean != null) {
            holder = new ConstantBeanHolder(this.bean, context, parameterMappingStrategy, beanComponent);
        } else if (this.beanName != null) {
            RegistryBean rb = new RegistryBean(context, this.beanName, parameterMappingStrategy, beanComponent);
            holder = this.scope == BeanScope.Singleton ? rb.createCacheHolder() : (this.scope == BeanScope.Request ? new RequestBeanHolder(rb) : rb);
        } else if (this.type != null) {
            ConstantTypeBeanHolder th = new ConstantTypeBeanHolder(this.type, context, parameterMappingStrategy, beanComponent);
            holder = this.scope == BeanScope.Singleton && ObjectHelper.hasDefaultPublicNoArgConstructor(this.type) ? th.createCacheHolder() : (this.scope == BeanScope.Request ? new RequestBeanHolder(th) : th);
        } else {
            throw new IllegalArgumentException("Either bean, beanName or type should be set on " + String.valueOf(this));
        }
        return holder;
    }

    private static String getBeanName(Exchange exchange, String beanName, BeanHolder beanHolder) {
        String name = beanName;
        if (name == null && beanHolder != null && beanHolder.getBean(exchange) != null) {
            name = beanHolder.getBean(exchange).getClass().getCanonicalName();
        }
        if (name == null && beanHolder != null && beanHolder.getBeanInfo() != null && beanHolder.getBeanInfo().getType() != null) {
            name = beanHolder.getBeanInfo().getType().getCanonicalName();
        }
        return name;
    }

    private static Object invokeBean(BeanHolder beanHolder, String beanName, String methodName, Exchange exchange) {
        Object result;
        try (BeanExpressionProcessor processor = new BeanExpressionProcessor(beanHolder);){
            if (methodName != null) {
                processor.setMethod(methodName);
                processor.setShorthandMethod(true);
            }
            Exchange resultExchange = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
            resultExchange.setException(null);
            resultExchange.setPattern(ExchangePattern.InOut);
            processor.process(resultExchange);
            Object object = result = resultExchange.hasOut() ? resultExchange.getOut().getBody() : null;
            if (resultExchange.hasProperties()) {
                exchange.getProperties().putAll(resultExchange.getProperties());
            }
            if (resultExchange.hasOut() && resultExchange.getOut().hasHeaders()) {
                exchange.getIn().getHeaders().putAll(resultExchange.getOut().getHeaders());
            }
            if (resultExchange.getException() != null) {
                exchange.setException((Throwable)resultExchange.getException());
            }
        }
        catch (Exception e) {
            throw new RuntimeBeanExpressionException(exchange, beanName, methodName, e);
        }
        return result;
    }

    private Object invokeOgnlMethod(BeanHolder beanHolder, String beanName, String ognl, Exchange exchange) {
        Object result = beanHolder.getBean(exchange);
        Exchange resultExchange = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
        resultExchange.setException(null);
        resultExchange.setPattern(ExchangePattern.InOut);
        resultExchange.getIn().removeHeader("CamelBeanMethodName");
        Object ognlPath = "";
        Object beanToCall = beanHolder.getBean(exchange);
        Class<?> beanType = beanHolder.getBeanInfo().getType();
        if (beanToCall == null && beanType == null) {
            throw new IllegalArgumentException("Bean instance and bean type is null. OGNL bean expressions requires to have either a bean instance of the class name of the bean to use.");
        }
        if (ognl != null) {
            OgnlHelper.validateMethodName((String)ognl);
        }
        List methods = OgnlHelper.splitOgnl((String)ognl);
        for (String methodName : methods) {
            BeanHolder holder = beanToCall != null ? new ConstantBeanHolder(beanToCall, exchange.getContext(), this.parameterMappingStrategy, this.beanComponent) : (beanType != null ? new ConstantTypeBeanHolder(beanType, exchange.getContext(), this.parameterMappingStrategy, this.beanComponent) : null);
            boolean nullSafe = OgnlHelper.isNullSafeOperator((String)methodName);
            if (holder == null) {
                String name = BeanExpression.getBeanName(exchange, null, beanHolder);
                throw new RuntimeBeanExpressionException(exchange, name, ognl, "last method returned null and therefore cannot continue to invoke method " + methodName + " on a null instance");
            }
            ognlPath = (String)ognlPath + methodName;
            methodName = OgnlHelper.removeLeadingOperators((String)methodName);
            String key = null;
            KeyValueHolder index = OgnlHelper.isOgnlIndex((String)methodName);
            if (index != null) {
                methodName = (String)index.getKey();
                key = (String)index.getValue();
            }
            if (methodName != null) {
                Object newResult = BeanExpression.invokeBean(holder, beanName, methodName, resultExchange);
                if (resultExchange.getException() != null) {
                    throw new RuntimeBeanExpressionException(exchange, beanName, methodName, resultExchange.getException());
                }
                result = newResult;
            }
            if (key != null) {
                if (LanguageSupport.hasSimpleFunction(key)) {
                    Expression exp = this.simple.createExpression(key);
                    exp.init(exchange.getContext());
                    key = (String)exp.evaluate(exchange, String.class);
                }
                if (key != null) {
                    result = BeanExpression.lookupResult(resultExchange, key, result, nullSafe, (String)ognlPath, holder.getBean(exchange));
                }
            }
            if (result == null && nullSafe) {
                return null;
            }
            beanToCall = result;
            beanType = null;
        }
        return result;
    }

    private static Object lookupResult(Exchange exchange, String key, Object result, boolean nullSafe, String ognlPath, Object bean) {
        List list;
        boolean checkList;
        StringHelper.notEmpty((String)key, (String)"key", (Object)("in Simple language ognl path: " + ognlPath));
        TypeConverter typeConverter = exchange.getContext().getTypeConverter();
        key = key.trim();
        key = StringHelper.removeLeadingAndEndingQuotes((String)key);
        Map map = (Map)typeConverter.convertTo(Map.class, result);
        if (map != null) {
            return map.get(key);
        }
        Integer num = (Integer)typeConverter.tryConvertTo(Integer.class, (Object)key);
        boolean bl = checkList = key.startsWith("last") || num != null;
        if (checkList && (list = (List)typeConverter.convertTo(List.class, result)) != null) {
            if (key.startsWith("last")) {
                num = list.size() - 1;
                String after = StringHelper.after((String)key, (String)"-");
                if (after != null) {
                    Integer redux = (Integer)typeConverter.tryConvertTo(Integer.class, (Object)after.trim());
                    if (redux != null) {
                        num = num - redux;
                    } else {
                        throw new ExpressionIllegalSyntaxException(key);
                    }
                }
            }
            if (num != null && num >= 0 && !list.isEmpty() && list.size() > num - 1) {
                return list.get(num);
            }
            if (!nullSafe) {
                throw new IndexOutOfBoundsException("Index: " + num + ", Size: " + list.size() + " out of bounds with List from bean: " + String.valueOf(bean) + "using OGNL path [" + ognlPath + "]");
            }
        }
        if (!nullSafe) {
            throw new IndexOutOfBoundsException("Key: " + key + " not found in bean: " + String.valueOf(bean) + " of type: " + ObjectHelper.classCanonicalName((Object)bean) + " using OGNL path [" + ognlPath + "]");
        }
        return null;
    }
}

