/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chatscript;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.chatscript.ChatScriptBot;
import org.apache.camel.component.chatscript.ChatScriptComponent;
import org.apache.camel.component.chatscript.ChatScriptProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="chatscript", title="ChatScript", syntax="chatscript:host:port/botName", producerOnly=true, category={Category.AI, Category.CHAT})
public class ChatScriptEndpoint
extends DefaultEndpoint {
    private ChatScriptBot bot;
    @UriPath(description="Hostname or IP of the server on which CS server is running")
    @Metadata(required=true)
    private String host;
    @UriPath(description="Port on which ChatScript is listening to", defaultValue="1024")
    private int port;
    @UriPath(description="Name of the Bot in CS to converse with")
    @Metadata(required=true)
    private String botName;
    @UriParam(description="Username who initializes the CS conversation. To be set when chat is initialized from camel route")
    private String chatUserName;
    @UriParam(description="Issues :reset command to start a new conversation everytime", defaultValue="false")
    private boolean resetChat;

    public ChatScriptEndpoint() {
    }

    public ChatScriptEndpoint(String uri, String remaining, ChatScriptComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        URI remainingUri = new URI("tcp://" + remaining);
        int n = this.port = remainingUri.getPort() == -1 ? 1024 : remainingUri.getPort();
        if (ObjectHelper.isEmpty((Object)remainingUri.getPath())) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form chatscript://host[:port]/botname?[options...]");
        }
        this.host = remainingUri.getHost();
        if (ObjectHelper.isEmpty((Object)this.host)) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form chatscript://host[:port]/botname?[options...]");
        }
        this.botName = remainingUri.getPath();
        if (ObjectHelper.isEmpty((Object)this.botName)) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form chatscript://host[:port]/botname?[options...]");
        }
        this.botName = this.botName.substring(1);
        this.setBot(new ChatScriptBot(this.getHost(), this.getPort(), this.getBotName(), ""));
    }

    public boolean isResetChat() {
        return this.resetChat;
    }

    public void setResetChat(boolean resetChat) {
        this.resetChat = resetChat;
    }

    public String getChatUserName() {
        return this.chatUserName;
    }

    public void setChatUserName(String chatusername) {
        this.chatUserName = chatusername;
    }

    public Producer createProducer() throws Exception {
        return new ChatScriptProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Chatscript consumer not supported");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String hostName) {
        this.host = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String botname) {
        this.botName = botname;
    }

    public static int getDefaultPort() {
        return 1024;
    }

    public ChatScriptBot getBot() {
        return this.bot;
    }

    public void setBot(ChatScriptBot thisBot) {
        this.bot = thisBot;
    }
}

