/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.mq.MQ2Component;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.mq.MqClient;

public interface Aws2MqComponentBuilderFactory {
    public static Aws2MqComponentBuilder aws2Mq() {
        return new Aws2MqComponentBuilderImpl();
    }

    public static class Aws2MqComponentBuilderImpl
    extends AbstractComponentBuilder<MQ2Component>
    implements Aws2MqComponentBuilder {
        @Override
        protected MQ2Component buildConcreteComponent() {
            return new MQ2Component();
        }

        private MQ2Configuration getOrCreateConfiguration(MQ2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MQ2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonMqClient": {
                    this.getOrCreateConfiguration((MQ2Component)component).setAmazonMqClient((MqClient)value);
                    return true;
                }
                case "configuration": {
                    ((MQ2Component)component).setConfiguration((MQ2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MQ2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MQ2Component)component).setOperation((MQ2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((MQ2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((MQ2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MQ2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((MQ2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MQ2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((MQ2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((MQ2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((MQ2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MQ2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2MqComponentBuilder
    extends ComponentBuilder<MQ2Component> {
        default public Aws2MqComponentBuilder amazonMqClient(MqClient amazonMqClient) {
            this.doSetProperty("amazonMqClient", amazonMqClient);
            return this;
        }

        default public Aws2MqComponentBuilder configuration(MQ2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2MqComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2MqComponentBuilder operation(MQ2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2MqComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2MqComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2MqComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2MqComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2MqComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2MqComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2MqComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2MqComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2MqComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

