/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponent;
import org.apache.camel.component.aws.firehose.KinesisFirehoseConfiguration;

public interface AwsKinesisFirehoseComponentBuilderFactory {
    public static AwsKinesisFirehoseComponentBuilder awsKinesisFirehose() {
        return new AwsKinesisFirehoseComponentBuilderImpl();
    }

    public static class AwsKinesisFirehoseComponentBuilderImpl
    extends AbstractComponentBuilder<KinesisFirehoseComponent>
    implements AwsKinesisFirehoseComponentBuilder {
        @Override
        protected KinesisFirehoseComponent buildConcreteComponent() {
            return new KinesisFirehoseComponent();
        }

        private KinesisFirehoseConfiguration getOrCreateConfiguration(KinesisFirehoseComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KinesisFirehoseConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonKinesisFirehoseClient": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setAmazonKinesisFirehoseClient((AmazonKinesisFirehose)value);
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((KinesisFirehoseComponent)component).setConfiguration((KinesisFirehoseConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KinesisFirehoseComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setRegion((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((KinesisFirehoseComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((KinesisFirehoseComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsKinesisFirehoseComponentBuilder
    extends ComponentBuilder<KinesisFirehoseComponent> {
        default public AwsKinesisFirehoseComponentBuilder amazonKinesisFirehoseClient(AmazonKinesisFirehose amazonKinesisFirehoseClient) {
            this.doSetProperty("amazonKinesisFirehoseClient", amazonKinesisFirehoseClient);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder configuration(KinesisFirehoseConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsKinesisFirehoseComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

