/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.blob.BlobServiceComponent;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;

public interface AzureBlobComponentBuilderFactory {
    @Deprecated
    public static AzureBlobComponentBuilder azureBlob() {
        return new AzureBlobComponentBuilderImpl();
    }

    public static class AzureBlobComponentBuilderImpl
    extends AbstractComponentBuilder<BlobServiceComponent>
    implements AzureBlobComponentBuilder {
        @Override
        protected BlobServiceComponent buildConcreteComponent() {
            return new BlobServiceComponent();
        }

        private BlobServiceConfiguration getOrCreateConfiguration(BlobServiceComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new BlobServiceConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "azureBlobClient": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setAzureBlobClient((CloudBlob)value);
                    return true;
                }
                case "blobOffset": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setBlobOffset((Long)value);
                    return true;
                }
                case "blobType": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setBlobType((BlobType)value);
                    return true;
                }
                case "closeStreamAfterRead": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setCloseStreamAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "credentials": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setCredentials((StorageCredentials)value);
                    return true;
                }
                case "dataLength": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setDataLength((Long)value);
                    return true;
                }
                case "fileDir": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setFileDir((String)value);
                    return true;
                }
                case "publicForRead": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setPublicForRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "streamReadSize": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setStreamReadSize(((Integer)value).intValue());
                    return true;
                }
                case "validateClientURI": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setValidateClientURI(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((BlobServiceComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "blobMetadata": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setBlobMetadata((Map)value);
                    return true;
                }
                case "blobPrefix": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setBlobPrefix((String)value);
                    return true;
                }
                case "closeStreamAfterWrite": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setCloseStreamAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((BlobServiceComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setOperation((BlobServiceOperations)value);
                    return true;
                }
                case "streamWriteSize": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setStreamWriteSize(((Integer)value).intValue());
                    return true;
                }
                case "useFlatListing": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setUseFlatListing(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((BlobServiceComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((BlobServiceComponent)component).setConfiguration((BlobServiceConfiguration)value);
                    return true;
                }
                case "credentialsAccountKey": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setCredentialsAccountKey((String)value);
                    return true;
                }
                case "credentialsAccountName": {
                    this.getOrCreateConfiguration((BlobServiceComponent)component).setCredentialsAccountName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureBlobComponentBuilder
    extends ComponentBuilder<BlobServiceComponent> {
        default public AzureBlobComponentBuilder azureBlobClient(CloudBlob azureBlobClient) {
            this.doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }

        default public AzureBlobComponentBuilder blobOffset(Long blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public AzureBlobComponentBuilder blobType(BlobType blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public AzureBlobComponentBuilder closeStreamAfterRead(boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public AzureBlobComponentBuilder credentials(StorageCredentials credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public AzureBlobComponentBuilder dataLength(Long dataLength) {
            this.doSetProperty("dataLength", dataLength);
            return this;
        }

        default public AzureBlobComponentBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        default public AzureBlobComponentBuilder publicForRead(boolean publicForRead) {
            this.doSetProperty("publicForRead", publicForRead);
            return this;
        }

        default public AzureBlobComponentBuilder streamReadSize(int streamReadSize) {
            this.doSetProperty("streamReadSize", streamReadSize);
            return this;
        }

        default public AzureBlobComponentBuilder validateClientURI(boolean validateClientURI) {
            this.doSetProperty("validateClientURI", validateClientURI);
            return this;
        }

        default public AzureBlobComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureBlobComponentBuilder blobMetadata(Map<String, String> blobMetadata) {
            this.doSetProperty("blobMetadata", blobMetadata);
            return this;
        }

        default public AzureBlobComponentBuilder blobPrefix(String blobPrefix) {
            this.doSetProperty("blobPrefix", blobPrefix);
            return this;
        }

        default public AzureBlobComponentBuilder closeStreamAfterWrite(boolean closeStreamAfterWrite) {
            this.doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }

        default public AzureBlobComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureBlobComponentBuilder operation(BlobServiceOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AzureBlobComponentBuilder streamWriteSize(int streamWriteSize) {
            this.doSetProperty("streamWriteSize", streamWriteSize);
            return this;
        }

        default public AzureBlobComponentBuilder useFlatListing(boolean useFlatListing) {
            this.doSetProperty("useFlatListing", useFlatListing);
            return this;
        }

        default public AzureBlobComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureBlobComponentBuilder configuration(BlobServiceConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureBlobComponentBuilder credentialsAccountKey(String credentialsAccountKey) {
            this.doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }

        default public AzureBlobComponentBuilder credentialsAccountName(String credentialsAccountName) {
            this.doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }
}

