/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.queue.QueueServiceComponent;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceOperations;

public interface AzureQueueComponentBuilderFactory {
    @Deprecated
    public static AzureQueueComponentBuilder azureQueue() {
        return new AzureQueueComponentBuilderImpl();
    }

    public static class AzureQueueComponentBuilderImpl
    extends AbstractComponentBuilder<QueueServiceComponent>
    implements AzureQueueComponentBuilder {
        @Override
        protected QueueServiceComponent buildConcreteComponent() {
            return new QueueServiceComponent();
        }

        private QueueServiceConfiguration getOrCreateConfiguration(QueueServiceComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new QueueServiceConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "azureQueueClient": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setAzureQueueClient((CloudQueue)value);
                    return true;
                }
                case "credentials": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setCredentials((StorageCredentials)value);
                    return true;
                }
                case "validateClientURI": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setValidateClientURI(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((QueueServiceComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((QueueServiceComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageTimeToLive": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setMessageTimeToLive(((Integer)value).intValue());
                    return true;
                }
                case "messageVisibilityDelay": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setMessageVisibilityDelay(((Integer)value).intValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setOperation((QueueServiceOperations)value);
                    return true;
                }
                case "queuePrefix": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setQueuePrefix((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((QueueServiceComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((QueueServiceComponent)component).setConfiguration((QueueServiceConfiguration)value);
                    return true;
                }
                case "credentialsAccountKey": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setCredentialsAccountKey((String)value);
                    return true;
                }
                case "credentialsAccountName": {
                    this.getOrCreateConfiguration((QueueServiceComponent)component).setCredentialsAccountName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureQueueComponentBuilder
    extends ComponentBuilder<QueueServiceComponent> {
        default public AzureQueueComponentBuilder azureQueueClient(CloudQueue azureQueueClient) {
            this.doSetProperty("azureQueueClient", azureQueueClient);
            return this;
        }

        default public AzureQueueComponentBuilder credentials(StorageCredentials credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public AzureQueueComponentBuilder validateClientURI(boolean validateClientURI) {
            this.doSetProperty("validateClientURI", validateClientURI);
            return this;
        }

        default public AzureQueueComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureQueueComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureQueueComponentBuilder messageTimeToLive(int messageTimeToLive) {
            this.doSetProperty("messageTimeToLive", messageTimeToLive);
            return this;
        }

        default public AzureQueueComponentBuilder messageVisibilityDelay(int messageVisibilityDelay) {
            this.doSetProperty("messageVisibilityDelay", messageVisibilityDelay);
            return this;
        }

        default public AzureQueueComponentBuilder operation(QueueServiceOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AzureQueueComponentBuilder queuePrefix(String queuePrefix) {
            this.doSetProperty("queuePrefix", queuePrefix);
            return this;
        }

        default public AzureQueueComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureQueueComponentBuilder configuration(QueueServiceConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureQueueComponentBuilder credentialsAccountKey(String credentialsAccountKey) {
            this.doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }

        default public AzureQueueComponentBuilder credentialsAccountName(String credentialsAccountName) {
            this.doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }
}

