/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="event")
@Configurer(bootstrap=true)
public class EventConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="25", description="Maximum capacity of last number of events to capture")
    private int capacity = 25;
    private Queue<CamelEvent> events;
    private Queue<CamelEvent.RouteEvent> routeEvents;
    private Queue<CamelEvent.ExchangeEvent> exchangeEvents;
    private final ConsoleEventNotifier listener = new ConsoleEventNotifier();

    public EventConsole() {
        super("camel", "event", "Camel Events", "The most recent Camel events");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected void doInit() throws Exception {
        this.events = new ArrayDeque<CamelEvent>(this.capacity);
        this.routeEvents = new ArrayDeque<CamelEvent.RouteEvent>(this.capacity);
        this.exchangeEvents = new ArrayDeque<CamelEvent.ExchangeEvent>(this.capacity);
    }

    protected void doStart() throws Exception {
        this.getCamelContext().getManagementStrategy().addEventNotifier((EventNotifier)this.listener);
    }

    protected void doStop() throws Exception {
        this.getCamelContext().getManagementStrategy().removeEventNotifier((EventNotifier)this.listener);
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.events != null && !this.events.isEmpty()) {
            sb.append(String.format("Last %s Camel Events:", this.events.size()));
            for (CamelEvent camelEvent : this.events) {
                if (camelEvent.getTimestamp() > 0L) {
                    sb.append(String.format("\n    %s (age: %s)", camelEvent, TimeUtils.printSince((long)camelEvent.getTimestamp())));
                    continue;
                }
                sb.append(String.format("\n    %s", camelEvent));
            }
            sb.append("\n");
        }
        if (this.routeEvents != null && !this.routeEvents.isEmpty()) {
            sb.append("\n");
            sb.append(String.format("Last %s Route Events:", this.routeEvents.size()));
            for (CamelEvent.RouteEvent routeEvent : this.routeEvents) {
                if (routeEvent.getTimestamp() > 0L) {
                    sb.append(String.format("\n    %s (age: %s)", routeEvent, TimeUtils.printSince((long)routeEvent.getTimestamp())));
                    continue;
                }
                sb.append(String.format("\n    %s", routeEvent));
            }
            sb.append("\n");
        }
        if (this.exchangeEvents != null && !this.exchangeEvents.isEmpty()) {
            sb.append("\n");
            sb.append(String.format("Last %s Exchange Events:", this.exchangeEvents.size()));
            for (CamelEvent.ExchangeEvent exchangeEvent : this.exchangeEvents) {
                if (exchangeEvent.getTimestamp() > 0L) {
                    sb.append(String.format("\n    %s (age: %s)", exchangeEvent, TimeUtils.printSince((long)exchangeEvent.getTimestamp())));
                    continue;
                }
                sb.append(String.format("\n    %s", exchangeEvent));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject jo;
        ArrayList<JsonObject> arr;
        JsonObject root = new JsonObject();
        if (this.events != null && !this.events.isEmpty()) {
            arr = new ArrayList<JsonObject>();
            for (CamelEvent camelEvent : this.events) {
                jo = new JsonObject();
                jo.put((Object)"type", (Object)camelEvent.getType().toString());
                if (camelEvent.getTimestamp() > 0L) {
                    jo.put((Object)"timestamp", (Object)camelEvent.getTimestamp());
                }
                jo.put((Object)"message", (Object)camelEvent.toString());
                arr.add(jo);
            }
            root.put((Object)"events", arr);
        }
        if (this.routeEvents != null && !this.routeEvents.isEmpty()) {
            arr = new ArrayList();
            for (CamelEvent camelEvent : this.routeEvents) {
                jo = new JsonObject();
                jo.put((Object)"type", (Object)camelEvent.getType().toString());
                if (camelEvent.getTimestamp() > 0L) {
                    jo.put((Object)"timestamp", (Object)camelEvent.getTimestamp());
                }
                jo.put((Object)"message", (Object)camelEvent.toString());
                arr.add(jo);
            }
            root.put((Object)"routeEvents", arr);
        }
        if (this.exchangeEvents != null && !this.exchangeEvents.isEmpty()) {
            arr = new ArrayList();
            for (CamelEvent.ExchangeEvent exchangeEvent : this.exchangeEvents) {
                jo = new JsonObject();
                jo.put((Object)"type", (Object)exchangeEvent.getType().toString());
                if (exchangeEvent.getTimestamp() > 0L) {
                    jo.put((Object)"timestamp", (Object)exchangeEvent.getTimestamp());
                }
                jo.put((Object)"exchangeId", (Object)exchangeEvent.getExchange().getExchangeId());
                jo.put((Object)"message", (Object)exchangeEvent.toString());
                arr.add(jo);
            }
            root.put((Object)"exchangeEvents", arr);
        }
        return root;
    }

    private class ConsoleEventNotifier
    extends EventNotifierSupport {
        private ConsoleEventNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if (event instanceof CamelEvent.ExchangeEvent) {
                if (EventConsole.this.exchangeEvents.size() >= EventConsole.this.capacity) {
                    EventConsole.this.exchangeEvents.poll();
                }
                EventConsole.this.exchangeEvents.add((CamelEvent.ExchangeEvent)event);
            } else if (event instanceof CamelEvent.RouteEvent) {
                if (EventConsole.this.routeEvents.size() >= EventConsole.this.capacity) {
                    EventConsole.this.routeEvents.poll();
                }
                EventConsole.this.routeEvents.add((CamelEvent.RouteEvent)event);
            } else {
                if (EventConsole.this.events.size() >= EventConsole.this.capacity) {
                    EventConsole.this.events.poll();
                }
                EventConsole.this.events.offer(event);
            }
        }
    }
}

