/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(value="top")
public class TopDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";

    public TopDevConsole() {
        super("camel", "top", "Top", "Display the top routes");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        StringBuilder sb = new StringBuilder();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            if (subPath == null || subPath.isBlank()) {
                Function<ManagedRouteMBean, Object> task = mrb -> {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(String.format("    Route Id: %s", mrb.getRouteId()));
                    sb.append(String.format("\n    From: %s", mrb.getEndpointUri()));
                    if (mrb.getSourceLocation() != null) {
                        sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
                    }
                    sb.append(String.format("\n    Total: %s", mrb.getExchangesTotal()));
                    sb.append(String.format("\n    Failed: %s", mrb.getExchangesFailed()));
                    sb.append(String.format("\n    Inflight: %s", mrb.getExchangesInflight()));
                    sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mrb.getMeanProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mrb.getMaxProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mrb.getMinProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration((long)mrb.getLastProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration((long)mrb.getDeltaProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Total Time: %s", TimeUtils.printDuration((long)mrb.getTotalProcessingTime(), (boolean)true)));
                    sb.append("\n");
                    return null;
                };
                this.topRoutes(filter, max, mcc, task);
            } else {
                Function<ManagedProcessorMBean, Object> task = mpb -> {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(String.format("    Route Id: %s", mpb.getRouteId()));
                    sb.append(String.format("\n    Processor Id: %s", mpb.getProcessorId()));
                    Object loc = mpb.getSourceLocation();
                    StringBuilder code = new StringBuilder();
                    if (loc != null && mpb.getSourceLineNumber() != null) {
                        int line = mpb.getSourceLineNumber();
                        try {
                            loc = LoggerHelper.stripSourceLocationLineNumber((String)loc);
                            Resource resource = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getResourceLoader().resolveResource((String)loc);
                            if (resource != null) {
                                LineNumberReader reader = new LineNumberReader(resource.getReader());
                                for (int i = 1; i < line + 3; ++i) {
                                    String t = reader.readLine();
                                    if (t == null) continue;
                                    int low = line - 2;
                                    int high = line + 4;
                                    if (i < low || i > high) continue;
                                    String arrow = i == line ? "-->" : "   ";
                                    code.append(String.format("\n        %s #%s %s", arrow, i, t));
                                }
                                IOHelper.close((Closeable)reader);
                            }
                            loc = (String)loc + ":" + mpb.getSourceLineNumber();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (loc != null) {
                        sb.append(String.format("\n    Source: %s", loc));
                        if (code.length() > 0) {
                            sb.append((CharSequence)code);
                        }
                    }
                    sb.append(String.format("\n    Total: %s", mpb.getExchangesTotal()));
                    sb.append(String.format("\n    Failed: %s", mpb.getExchangesFailed()));
                    sb.append(String.format("\n    Inflight: %s", mpb.getExchangesInflight()));
                    sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mpb.getMeanProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mpb.getMaxProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mpb.getMinProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration((long)mpb.getLastProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration((long)mpb.getDeltaProcessingTime(), (boolean)true)));
                    sb.append(String.format("\n    Total Time: %s", TimeUtils.printDuration((long)mpb.getTotalProcessingTime(), (boolean)true)));
                    sb.append("\n");
                    return null;
                };
                this.topProcessors(filter, subPath, max, mcc, task);
            }
        }
        return sb.toString();
    }

    @Override
    protected JsonObject doCallJson(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            if (subPath == null || subPath.isBlank()) {
                Function<ManagedRouteMBean, Object> task = mrb -> {
                    JsonObject jo = new JsonObject();
                    list.add(jo);
                    jo.put((Object)"routeId", (Object)mrb.getRouteId());
                    jo.put((Object)"from", (Object)mrb.getEndpointUri());
                    if (mrb.getSourceLocation() != null) {
                        jo.put((Object)"source", (Object)mrb.getSourceLocation());
                    }
                    jo.put((Object)"state", (Object)mrb.getState());
                    jo.put((Object)"uptime", (Object)mrb.getUptime());
                    JsonObject stats = new JsonObject();
                    stats.put((Object)"exchangesTotal", (Object)mrb.getExchangesTotal());
                    stats.put((Object)"exchangesFailed", (Object)mrb.getExchangesFailed());
                    stats.put((Object)"exchangesInflight", (Object)mrb.getExchangesInflight());
                    stats.put((Object)"meanProcessingTime", (Object)mrb.getMeanProcessingTime());
                    stats.put((Object)"maxProcessingTime", (Object)mrb.getMaxProcessingTime());
                    stats.put((Object)"minProcessingTime", (Object)mrb.getMinProcessingTime());
                    stats.put((Object)"lastProcessingTime", (Object)mrb.getLastProcessingTime());
                    stats.put((Object)"deltaProcessingTime", (Object)mrb.getDeltaProcessingTime());
                    stats.put((Object)"totalProcessingTime", (Object)mrb.getTotalProcessingTime());
                    jo.put((Object)"statistics", (Object)stats);
                    return null;
                };
                this.topRoutes(filter, max, mcc, task);
                root.put((Object)"routes", list);
            } else {
                Function<ManagedProcessorMBean, Object> task = mpb -> {
                    JsonObject jo = new JsonObject();
                    list.add(jo);
                    jo.put((Object)"routeId", (Object)mpb.getRouteId());
                    jo.put((Object)"processorId", (Object)mpb.getProcessorId());
                    Object loc = mpb.getSourceLocation();
                    ArrayList<JsonObject> code = new ArrayList<JsonObject>();
                    if (loc != null && mpb.getSourceLineNumber() != null) {
                        int line = mpb.getSourceLineNumber();
                        try {
                            loc = LoggerHelper.stripSourceLocationLineNumber((String)loc);
                            Resource resource = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getResourceLoader().resolveResource((String)loc);
                            if (resource != null) {
                                LineNumberReader reader = new LineNumberReader(resource.getReader());
                                for (int i = 1; i < line + 3; ++i) {
                                    String t = reader.readLine();
                                    if (t == null) continue;
                                    int low = line - 2;
                                    int high = line + 4;
                                    if (i < low || i > high) continue;
                                    JsonObject c = new JsonObject();
                                    c.put((Object)"line", (Object)i);
                                    if (line == i) {
                                        c.put((Object)"match", (Object)true);
                                    }
                                    c.put((Object)"code", (Object)Jsoner.escape((String)t));
                                    code.add(c);
                                }
                                IOHelper.close((Closeable)reader);
                            }
                            loc = (String)loc + ":" + mpb.getSourceLineNumber();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (loc != null) {
                        jo.put((Object)"location", loc);
                        if (!code.isEmpty()) {
                            jo.put((Object)"code", code);
                        }
                    }
                    JsonObject stats = new JsonObject();
                    stats.put((Object)"exchangesTotal", (Object)mpb.getExchangesTotal());
                    stats.put((Object)"exchangesFailed", (Object)mpb.getExchangesFailed());
                    stats.put((Object)"exchangesInflight", (Object)mpb.getExchangesInflight());
                    stats.put((Object)"meanProcessingTime", (Object)mpb.getMeanProcessingTime());
                    stats.put((Object)"maxProcessingTime", (Object)mpb.getMaxProcessingTime());
                    stats.put((Object)"minProcessingTime", (Object)mpb.getMinProcessingTime());
                    stats.put((Object)"lastProcessingTime", (Object)mpb.getLastProcessingTime());
                    stats.put((Object)"deltaProcessingTime", (Object)mpb.getDeltaProcessingTime());
                    stats.put((Object)"totalProcessingTime", (Object)mpb.getTotalProcessingTime());
                    jo.put((Object)"statistics", (Object)stats);
                    return null;
                };
                this.topProcessors(filter, subPath, max, mcc, task);
                root.put((Object)"processors", list);
            }
        }
        return root;
    }

    private void topRoutes(String filter, int max, ManagedCamelContext mcc, Function<ManagedRouteMBean, Object> task) {
        List routes = this.getCamelContext().getRoutes();
        routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(r -> TopDevConsole.acceptRoute(r, filter)).sorted(TopDevConsole::top).limit(max).forEach(task::apply);
    }

    private void topProcessors(String filter, String subPath, int max, ManagedCamelContext mcc, Function<ManagedProcessorMBean, Object> task) {
        List routes = this.getCamelContext().getRoutes();
        ArrayList ids = new ArrayList();
        routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(r -> TopDevConsole.acceptRoute(r, subPath)).forEach(r -> {
            try {
                ids.addAll(r.processorIds());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ids.stream().map(arg_0 -> ((ManagedCamelContext)mcc).getManagedProcessor(arg_0)).filter(p -> TopDevConsole.acceptProcessor(p, filter)).sorted(TopDevConsole::top).limit(max).forEach(task::apply);
    }

    private static boolean acceptRoute(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter);
    }

    private static boolean acceptProcessor(ManagedProcessorMBean mpb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)mpb.getProcessorId(), (String)filter) || PatternHelper.matchPattern((String)mpb.getSourceLocation(), (String)filter);
    }

    private static int top(ManagedPerformanceCounterMBean o1, ManagedPerformanceCounterMBean o2) {
        long m2;
        long m1 = o1.getMeanProcessingTime();
        if (m1 < (m2 = o2.getMeanProcessingTime())) {
            return 1;
        }
        if (m1 > m2) {
            return -1;
        }
        return 0;
    }
}

