/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.cxf.common.header.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.common.message.CxfMessageMapper;
import org.apache.camel.component.cxf.common.message.DefaultCxfMesssageMapper;
import org.apache.camel.component.cxf.cxfbean.CxfBeanComponent;
import org.apache.camel.component.cxf.cxfbean.CxfBeanTransportFactory;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.CamelContextHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

public class CxfBeanEndpoint
extends ProcessorEndpoint
implements HeaderFilterStrategyAware {
    private static final String URI_PREFIX = "cxfbean";
    private Server server;
    private Bus bus;
    private boolean isSetDefaultBus;
    private CxfMessageMapper cxfBeanBinding = new DefaultCxfMesssageMapper();
    private HeaderFilterStrategy headerFilterStrategy = new CxfHeaderFilterStrategy();
    private boolean loggingFeatureEnabled;
    private boolean populateFromClass = true;
    private List<Object> providers;

    public CxfBeanEndpoint(String remaining, CxfBeanComponent component) {
        super(remaining, (Component)component);
    }

    protected void doStart() throws Exception {
        this.server.start();
    }

    protected void doStop() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ArrayList<Object> serviceBeans;
        Object obj = CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.getEndpointUri());
        if (obj instanceof List) {
            serviceBeans = (ArrayList<Object>)obj;
        } else {
            serviceBeans = new ArrayList<Object>(1);
            serviceBeans.add(obj);
        }
        if (this.bus == null) {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(BusFactory.class.getClassLoader());
                this.bus = BusFactory.newInstance().createBus();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        if (this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
        }
        this.registerTransportFactory((CxfBeanComponent)this.getComponent());
        this.createServer(serviceBeans);
    }

    protected String createEndpointUri() {
        return "cxfbean:" + this.getEndpointUri();
    }

    private void createServer(List<Object> serviceBeans) {
        WebService obj = serviceBeans.get(0).getClass().getAnnotation(WebService.class);
        if (obj != null) {
            JaxWsServerFactoryBean bean = new JaxWsServerFactoryBean();
            bean.setTransportId("http://cxf.apache.org/transports/camel/cxfbean");
            bean.setServiceClass(serviceBeans.get(0).getClass());
            bean.setServiceBean(serviceBeans.get(0));
            if (bean.getServiceFactory() != null) {
                bean.getServiceFactory().setPopulateFromClass(this.isPopulateFromClass());
            }
            bean.setBus(this.bus);
            bean.setStart(true);
            bean.setAddress("camel://" + this.createEndpointUri());
            if (this.loggingFeatureEnabled) {
                bean.getFeatures().add(new LoggingFeature());
            }
            this.server = bean.create();
        } else {
            JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
            bean.setServiceBeans(serviceBeans);
            bean.setAddress("camel://" + this.createEndpointUri());
            bean.setStart(true);
            bean.setTransportId("http://cxf.apache.org/transports/camel/cxfbean");
            bean.setBus(this.bus);
            if (this.loggingFeatureEnabled) {
                bean.getFeatures().add(new LoggingFeature());
            }
            bean.setProviders(this.providers);
            this.server = bean.create();
        }
    }

    private void registerTransportFactory(CxfBeanComponent cxfBeanComponent) {
        CxfBeanTransportFactory transportFactory = new CxfBeanTransportFactory();
        transportFactory.setCxfBeanComponent(cxfBeanComponent);
        transportFactory.setBus(this.bus);
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        cim.registerConduitInitiator("http://cxf.apache.org/transports/camel/cxfbean", (ConduitInitiator)transportFactory);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/camel/cxfbean", (DestinationFactory)transportFactory);
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public void setCxfBeanBinding(CxfMessageMapper cxfBeanBinding) {
        this.cxfBeanBinding = cxfBeanBinding;
    }

    public CxfMessageMapper getCxfBeanBinding() {
        return this.cxfBeanBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public void setPopulateFromClass(boolean populateFromClass) {
        this.populateFromClass = populateFromClass;
    }

    public boolean isPopulateFromClass() {
        return this.populateFromClass;
    }

    public List<Object> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }
}

