/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Application;
import ai.djl.inference.Predictor;
import ai.djl.modality.Classifications;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.camel.Exchange;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooImageClassificationPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(ZooImageClassificationPredictor.class);
    private final ZooModel<BufferedImage, Classifications> model;

    public ZooImageClassificationPredictor(String artifactId) throws Exception {
        Criteria criteria = Criteria.builder().optApplication(Application.CV.IMAGE_CLASSIFICATION).setTypes(BufferedImage.class, Classifications.class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (exchange.getIn().getBody() instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            Map<String, Float> result = this.classify(new ByteArrayInputStream(bytes));
            exchange.getIn().setBody(result);
        } else if (exchange.getIn().getBody() instanceof File) {
            Map<String, Float> result = this.classify((File)exchange.getIn().getBody(File.class));
            exchange.getIn().setBody(result);
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            Map<String, Float> result = this.classify((InputStream)exchange.getIn().getBody(InputStream.class));
            exchange.getIn().setBody(result);
        } else {
            throw new RuntimeException("Data type is not supported. Body should be byte[], InputStream or File");
        }
    }

    public Map<String, Float> classify(File input) throws Exception {
        try {
            return this.classify(ImageIO.read(input));
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeException("Couldn't transform input into a BufferedImage", e);
        }
    }

    public Map<String, Float> classify(InputStream input) throws Exception {
        try {
            return this.classify(ImageIO.read(input));
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeException("Couldn't transform input into a BufferedImage", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Float> classify(BufferedImage input) throws Exception {
        try (Predictor predictor = this.model.newPredictor();){
            Classifications classifications = (Classifications)predictor.predict((Object)input);
            List list = classifications.items();
            Map<String, Float> map = list.stream().collect(Collectors.toMap(Classifications.Classification::getClassName, x -> Float.valueOf((float)x.getProbability())));
            return map;
        }
        catch (TranslateException e) {
            LOG.error("Could not process input or output", (Throwable)e);
            throw new RuntimeException("Could not process input or output", e);
        }
    }
}

