/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteBuilderLifecycleStrategy;
import org.apache.camel.dsl.support.DefaultSourceLoader;
import org.apache.camel.dsl.support.SourceLoader;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.CompilePreProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.RoutesBuilderLoaderSupport;

public abstract class RouteBuilderLoaderSupport
extends RoutesBuilderLoaderSupport {
    private final String extension;
    private final List<CompilePreProcessor> compilePreProcessors = new ArrayList<CompilePreProcessor>();
    private final List<CompilePostProcessor> compilePostProcessors = new ArrayList<CompilePostProcessor>();
    private StartupStepRecorder recorder;
    private SourceLoader sourceLoader = new DefaultSourceLoader();

    protected RouteBuilderLoaderSupport(String extension) {
        this.extension = extension;
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return this.extension;
    }

    @ManagedOperation(description="Is the file extension supported by this route loader")
    public boolean isSupportedExtension(String extension) {
        return super.isSupportedExtension(extension);
    }

    public List<CompilePreProcessor> getCompilePreProcessors() {
        return this.compilePreProcessors;
    }

    public void addCompilePreProcessor(CompilePreProcessor preProcessor) {
        this.compilePreProcessors.add(preProcessor);
    }

    public List<CompilePostProcessor> getCompilePostProcessors() {
        return this.compilePostProcessors;
    }

    public void addCompilePostProcessor(CompilePostProcessor preProcessor) {
        this.compilePostProcessors.add(preProcessor);
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.getCamelContext() != null) {
            this.recorder = this.getCamelContext().getCamelContextExtension().getStartupStepRecorder();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getCamelContext() != null) {
            SourceLoader sl;
            Set posts;
            Set pres = this.getCamelContext().getRegistry().findByType(CompilePreProcessor.class);
            if (pres != null && !pres.isEmpty()) {
                for (Object pre : pres) {
                    this.addCompilePreProcessor((CompilePreProcessor)pre);
                }
            }
            if ((posts = this.getCamelContext().getRegistry().findByType(CompilePostProcessor.class)) != null && !posts.isEmpty()) {
                for (CompilePostProcessor post : posts) {
                    this.addCompilePostProcessor(post);
                }
            }
            if ((sl = (SourceLoader)this.getCamelContext().getRegistry().findSingleByType(SourceLoader.class)) != null) {
                this.sourceLoader = sl;
            }
        }
    }

    public RoutesBuilder loadRoutesBuilder(Resource resource) throws Exception {
        RouteBuilder builder = this.doLoadRouteBuilder(resource);
        if (builder != null) {
            CamelContextAware.trySetCamelContext((Object)builder, (CamelContext)this.getCamelContext());
            builder.setResource(resource);
            if (this.recorder != null) {
                final StartupStep step = this.recorder.beginStep(((Object)((Object)this)).getClass(), resource.getLocation(), "Loading route from: " + resource.getLocation());
                builder.addLifecycleInterceptor(new RouteBuilderLifecycleStrategy(){

                    public void afterConfigure(RouteBuilder builder) {
                        step.endStep();
                    }
                });
            }
        }
        return builder;
    }

    protected InputStream resourceInputStream(Resource resource) throws IOException {
        String data = this.sourceLoader.loadResource(resource);
        if (data.isBlank()) {
            throw new IOException("Resource is empty: " + resource.getLocation());
        }
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract RouteBuilder doLoadRouteBuilder(Resource var1) throws Exception;
}

