/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The ldif component allows you to do updates on an LDAP server from a LDIF
 * body content.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface LdifEndpointBuilderFactory {


    /**
     * Builder for endpoint for the LDIF component.
     */
    public interface LdifEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedLdifEndpointBuilder advanced() {
            return (AdvancedLdifEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default LdifEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default LdifEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the LDIF component.
     */
    public interface AdvancedLdifEndpointBuilder
            extends
                EndpointProducerBuilder {
        default LdifEndpointBuilder basic() {
            return (LdifEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLdifEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLdifEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLdifEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLdifEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface LdifBuilders {
        /**
         * LDIF (camel-ldif)
         * The ldif component allows you to do updates on an LDAP server from a
         * LDIF body content.
         * 
         * Category: ldap
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-ldif
         * 
         * Syntax: <code>ldif:ldapConnectionName</code>
         * 
         * Path parameter: ldapConnectionName (required)
         * The name of the LdapConnection bean to pull from the registry. Note
         * that this must be of scope prototype to avoid it being shared among
         * threads or using a connection that has timed out.
         */
        default LdifEndpointBuilder ldif(String path) {
            return LdifEndpointBuilderFactory.ldif(path);
        }
    }
    /**
     * LDIF (camel-ldif)
     * The ldif component allows you to do updates on an LDAP server from a LDIF
     * body content.
     * 
     * Category: ldap
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     * 
     * Syntax: <code>ldif:ldapConnectionName</code>
     * 
     * Path parameter: ldapConnectionName (required)
     * The name of the LdapConnection bean to pull from the registry. Note that
     * this must be of scope prototype to avoid it being shared among threads or
     * using a connection that has timed out.
     */
    static LdifEndpointBuilder ldif(String path) {
        class LdifEndpointBuilderImpl extends AbstractEndpointBuilder implements LdifEndpointBuilder, AdvancedLdifEndpointBuilder {
            public LdifEndpointBuilderImpl(String path) {
                super("ldif", path);
            }
        }
        return new LdifEndpointBuilderImpl(path);
    }
}