/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * The beanstalk component is used for job retrieval and post-processing of
 * Beanstalk jobs.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BeanstalkEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Beanstalk component.
     */
    public interface BeanstalkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBeanstalkEndpointConsumerBuilder advanced() {
            return (AdvancedBeanstalkEndpointConsumerBuilder) this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option is a:
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder command(
                BeanstalkCommand command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobDelay(int jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobDelay(String jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobPriority(long jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobPriority(String jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobTimeToRun(int jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointConsumerBuilder jobTimeToRun(
                String jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
        /**
         * Whether to wait for job to complete before ack the job from
         * beanstalk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder awaitJob(boolean awaitJob) {
            doSetProperty("awaitJob", awaitJob);
            return this;
        }
        /**
         * Whether to wait for job to complete before ack the job from
         * beanstalk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder awaitJob(String awaitJob) {
            doSetProperty("awaitJob", awaitJob);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Command to use when processing failed.
         * 
         * The option is a:
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder onFailure(
                BeanstalkCommand onFailure) {
            doSetProperty("onFailure", onFailure);
            return this;
        }
        /**
         * Command to use when processing failed.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder onFailure(String onFailure) {
            doSetProperty("onFailure", onFailure);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Whether to use blockIO.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder useBlockIO(boolean useBlockIO) {
            doSetProperty("useBlockIO", useBlockIO);
            return this;
        }
        /**
         * Whether to use blockIO.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default BeanstalkEndpointConsumerBuilder useBlockIO(String useBlockIO) {
            doSetProperty("useBlockIO", useBlockIO);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BeanstalkEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Beanstalk component.
     */
    public interface AdvancedBeanstalkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BeanstalkEndpointConsumerBuilder basic() {
            return (BeanstalkEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBeanstalkEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Beanstalk component.
     */
    public interface BeanstalkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBeanstalkEndpointProducerBuilder advanced() {
            return (AdvancedBeanstalkEndpointProducerBuilder) this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option is a:
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder command(
                BeanstalkCommand command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobDelay(int jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobDelay(String jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobPriority(long jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobPriority(String jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobTimeToRun(int jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointProducerBuilder jobTimeToRun(
                String jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BeanstalkEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BeanstalkEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Beanstalk component.
     */
    public interface AdvancedBeanstalkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BeanstalkEndpointProducerBuilder basic() {
            return (BeanstalkEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Beanstalk component.
     */
    public interface BeanstalkEndpointBuilder
            extends
                BeanstalkEndpointConsumerBuilder,
                BeanstalkEndpointProducerBuilder {
        default AdvancedBeanstalkEndpointBuilder advanced() {
            return (AdvancedBeanstalkEndpointBuilder) this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option is a:
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointBuilder command(BeanstalkCommand command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * put means to put the job into Beanstalk. Job body is specified in the
         * Camel message body. Job ID will be returned in beanstalk.jobId
         * message header. delete, release, touch or bury expect Job ID in the
         * message header beanstalk.jobId. Result of the operation is returned
         * in beanstalk.result message header kick expects the number of jobs to
         * kick in the message body and returns the number of jobs actually
         * kicked out in the message header beanstalk.result.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code>
         * type.
         * 
         * Group: common
         */
        default BeanstalkEndpointBuilder command(String command) {
            doSetProperty("command", command);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointBuilder jobDelay(int jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job delay in seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BeanstalkEndpointBuilder jobDelay(String jobDelay) {
            doSetProperty("jobDelay", jobDelay);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointBuilder jobPriority(long jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job priority. (0 is the highest, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default BeanstalkEndpointBuilder jobPriority(String jobPriority) {
            doSetProperty("jobPriority", jobPriority);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointBuilder jobTimeToRun(int jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
        /**
         * Job time to run in seconds. (when 0, the beanstalkd daemon raises it
         * to 1 automatically, see Beanstalk protocol).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         */
        default BeanstalkEndpointBuilder jobTimeToRun(String jobTimeToRun) {
            doSetProperty("jobTimeToRun", jobTimeToRun);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Beanstalk component.
     */
    public interface AdvancedBeanstalkEndpointBuilder
            extends
                AdvancedBeanstalkEndpointConsumerBuilder,
                AdvancedBeanstalkEndpointProducerBuilder {
        default BeanstalkEndpointBuilder basic() {
            return (BeanstalkEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBeanstalkEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.beanstalk.BeanstalkCommand</code> enum.
     */
    enum BeanstalkCommand {
        bury,
        release,
        put,
        touch,
        delete,
        kick;
    }

    public interface BeanstalkBuilders {
        /**
         * Beanstalk (camel-beanstalk)
         * The beanstalk component is used for job retrieval and post-processing
         * of Beanstalk jobs.
         * 
         * Category: messaging
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-beanstalk
         * 
         * Syntax: <code>beanstalk:connectionSettings</code>
         * 
         * Path parameter: connectionSettings
         * Connection settings host:port/tube
         */
        default BeanstalkEndpointBuilder beanstalk(String path) {
            return BeanstalkEndpointBuilderFactory.beanstalk(path);
        }
    }
    /**
     * Beanstalk (camel-beanstalk)
     * The beanstalk component is used for job retrieval and post-processing of
     * Beanstalk jobs.
     * 
     * Category: messaging
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-beanstalk
     * 
     * Syntax: <code>beanstalk:connectionSettings</code>
     * 
     * Path parameter: connectionSettings
     * Connection settings host:port/tube
     */
    static BeanstalkEndpointBuilder beanstalk(String path) {
        class BeanstalkEndpointBuilderImpl extends AbstractEndpointBuilder implements BeanstalkEndpointBuilder, AdvancedBeanstalkEndpointBuilder {
            public BeanstalkEndpointBuilderImpl(String path) {
                super("beanstalk", path);
            }
        }
        return new BeanstalkEndpointBuilderImpl(path);
    }
}