/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Represents a Couchbase endpoint that can query Views with a Poll strategy
 * and/or produce various type of operations.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CouchbaseEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Couchbase component.
     */
    public interface CouchbaseEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCouchbaseEndpointConsumerBuilder advanced() {
            return (AdvancedCouchbaseEndpointConsumerBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointConsumerBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointConsumerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Define the consumer Processed strategy to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder consumerProcessedStrategy(
                String consumerProcessedStrategy) {
            doSetProperty("consumerProcessedStrategy", consumerProcessedStrategy);
            return this;
        }
        /**
         * Define if this operation is descending or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder descending(boolean descending) {
            doSetProperty("descending", descending);
            return this;
        }
        /**
         * Define if this operation is descending or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder descending(String descending) {
            doSetProperty("descending", descending);
            return this;
        }
        /**
         * The design document name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: beer
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder designDocumentName(
                String designDocumentName) {
            doSetProperty("designDocumentName", designDocumentName);
            return this;
        }
        /**
         * The output limit to use.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder limit(int limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * The output limit to use.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Define a range for the end key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder rangeEndKey(String rangeEndKey) {
            doSetProperty("rangeEndKey", rangeEndKey);
            return this;
        }
        /**
         * Define a range for the start key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder rangeStartKey(
                String rangeStartKey) {
            doSetProperty("rangeStartKey", rangeStartKey);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Define the skip to use.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder skip(int skip) {
            doSetProperty("skip", skip);
            return this;
        }
        /**
         * Define the skip to use.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder skip(String skip) {
            doSetProperty("skip", skip);
            return this;
        }
        /**
         * The view name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: brewery_beers
         * Group: consumer
         */
        default CouchbaseEndpointConsumerBuilder viewName(String viewName) {
            doSetProperty("viewName", viewName);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CouchbaseEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CouchbaseEndpointConsumerBuilder basic() {
            return (CouchbaseEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCouchbaseEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder maxReconnectDelay(
                long maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder maxReconnectDelay(
                String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder obsPollInterval(
                long obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder obsPollInterval(
                String obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder obsTimeout(
                long obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder obsTimeout(
                String obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder opQueueMaxBlockTime(
                long opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder opQueueMaxBlockTime(
                String opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder opTimeOut(
                long opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder opTimeOut(
                String opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder readBufferSize(
                int readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder readBufferSize(
                String readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder shouldOptimize(
                boolean shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder shouldOptimize(
                String shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder timeoutExceptionThreshold(
                int timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointConsumerBuilder timeoutExceptionThreshold(
                String timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Couchbase component.
     */
    public interface CouchbaseEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCouchbaseEndpointProducerBuilder advanced() {
            return (AdvancedCouchbaseEndpointProducerBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointProducerBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Define if we want an autostart Id when we are doing an insert
         * operation.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder autoStartIdForInserts(
                boolean autoStartIdForInserts) {
            doSetProperty("autoStartIdForInserts", autoStartIdForInserts);
            return this;
        }
        /**
         * Define if we want an autostart Id when we are doing an insert
         * operation.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder autoStartIdForInserts(
                String autoStartIdForInserts) {
            doSetProperty("autoStartIdForInserts", autoStartIdForInserts);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The operation to do.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: CCB_PUT
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Where to persist the data.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder persistTo(int persistTo) {
            doSetProperty("persistTo", persistTo);
            return this;
        }
        /**
         * Where to persist the data.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder persistTo(String persistTo) {
            doSetProperty("persistTo", persistTo);
            return this;
        }
        /**
         * Define the number of retry attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder producerRetryAttempts(
                int producerRetryAttempts) {
            doSetProperty("producerRetryAttempts", producerRetryAttempts);
            return this;
        }
        /**
         * Define the number of retry attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder producerRetryAttempts(
                String producerRetryAttempts) {
            doSetProperty("producerRetryAttempts", producerRetryAttempts);
            return this;
        }
        /**
         * Define the retry pause between different attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder producerRetryPause(
                int producerRetryPause) {
            doSetProperty("producerRetryPause", producerRetryPause);
            return this;
        }
        /**
         * Define the retry pause between different attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder producerRetryPause(
                String producerRetryPause) {
            doSetProperty("producerRetryPause", producerRetryPause);
            return this;
        }
        /**
         * Where to replicate the data.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder replicateTo(int replicateTo) {
            doSetProperty("replicateTo", replicateTo);
            return this;
        }
        /**
         * Where to replicate the data.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder replicateTo(String replicateTo) {
            doSetProperty("replicateTo", replicateTo);
            return this;
        }
        /**
         * Define the starting Id where we are doing an insert operation.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder startingIdForInsertsFrom(
                long startingIdForInsertsFrom) {
            doSetProperty("startingIdForInsertsFrom", startingIdForInsertsFrom);
            return this;
        }
        /**
         * Define the starting Id where we are doing an insert operation.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default CouchbaseEndpointProducerBuilder startingIdForInsertsFrom(
                String startingIdForInsertsFrom) {
            doSetProperty("startingIdForInsertsFrom", startingIdForInsertsFrom);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CouchbaseEndpointProducerBuilder basic() {
            return (CouchbaseEndpointProducerBuilder) this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder maxReconnectDelay(
                long maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder maxReconnectDelay(
                String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder obsPollInterval(
                long obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder obsPollInterval(
                String obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder obsTimeout(
                long obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder obsTimeout(
                String obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder opQueueMaxBlockTime(
                long opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder opQueueMaxBlockTime(
                String opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder opTimeOut(
                long opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder opTimeOut(
                String opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder readBufferSize(
                int readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder readBufferSize(
                String readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder shouldOptimize(
                boolean shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder shouldOptimize(
                String shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder timeoutExceptionThreshold(
                int timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointProducerBuilder timeoutExceptionThreshold(
                String timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Couchbase component.
     */
    public interface CouchbaseEndpointBuilder
            extends
                CouchbaseEndpointConsumerBuilder,
                CouchbaseEndpointProducerBuilder {
        default AdvancedCouchbaseEndpointBuilder advanced() {
            return (AdvancedCouchbaseEndpointBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CouchbaseEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default CouchbaseEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointBuilder
            extends
                AdvancedCouchbaseEndpointConsumerBuilder,
                AdvancedCouchbaseEndpointProducerBuilder {
        default CouchbaseEndpointBuilder basic() {
            return (CouchbaseEndpointBuilder) this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder maxReconnectDelay(
                long maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the max delay during a reconnection.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder maxReconnectDelay(
                String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder obsPollInterval(
                long obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation polling interval.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 400
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder obsPollInterval(
                String obsPollInterval) {
            doSetProperty("obsPollInterval", obsPollInterval);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder obsTimeout(long obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the observation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder obsTimeout(String obsTimeout) {
            doSetProperty("obsTimeout", obsTimeout);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder opQueueMaxBlockTime(
                long opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the max time an operation can be in queue blocked.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder opQueueMaxBlockTime(
                String opQueueMaxBlockTime) {
            doSetProperty("opQueueMaxBlockTime", opQueueMaxBlockTime);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder opTimeOut(long opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the operation timeout.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder opTimeOut(String opTimeOut) {
            doSetProperty("opTimeOut", opTimeOut);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder readBufferSize(
                int readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define the buffer size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 16384
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder readBufferSize(
                String readBufferSize) {
            doSetProperty("readBufferSize", readBufferSize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder shouldOptimize(
                boolean shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Define if we want to use optimization or not where possible.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder shouldOptimize(
                String shouldOptimize) {
            doSetProperty("shouldOptimize", shouldOptimize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder timeoutExceptionThreshold(
                int timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
        /**
         * Define the threshold for throwing a timeout Exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 998
         * Group: advanced
         */
        default AdvancedCouchbaseEndpointBuilder timeoutExceptionThreshold(
                String timeoutExceptionThreshold) {
            doSetProperty("timeoutExceptionThreshold", timeoutExceptionThreshold);
            return this;
        }
    }

    public interface CouchbaseBuilders {
        /**
         * Couchbase (camel-couchbase)
         * Represents a Couchbase endpoint that can query Views with a Poll
         * strategy and/or produce various type of operations.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-couchbase
         * 
         * Syntax: <code>couchbase:protocol:hostname:port</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use
         * 
         * Path parameter: hostname (required)
         * The hostname to use
         * 
         * Path parameter: port
         * The port number to use
         * Default value: 8091
         */
        default CouchbaseEndpointBuilder couchbase(String path) {
            return CouchbaseEndpointBuilderFactory.couchbase(path);
        }
    }
    /**
     * Couchbase (camel-couchbase)
     * Represents a Couchbase endpoint that can query Views with a Poll strategy
     * and/or produce various type of operations.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     * 
     * Syntax: <code>couchbase:protocol:hostname:port</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use
     * 
     * Path parameter: hostname (required)
     * The hostname to use
     * 
     * Path parameter: port
     * The port number to use
     * Default value: 8091
     */
    static CouchbaseEndpointBuilder couchbase(String path) {
        class CouchbaseEndpointBuilderImpl extends AbstractEndpointBuilder implements CouchbaseEndpointBuilder, AdvancedCouchbaseEndpointBuilder {
            public CouchbaseEndpointBuilderImpl(String path) {
                super("couchbase", path);
            }
        }
        return new CouchbaseEndpointBuilderImpl(path);
    }
}