/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * The ironmq provides integration with IronMQ an elastic and durable hosted
 * message queue as a service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IronMQEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IronMQ component.
     */
    public interface IronMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedIronMQEndpointConsumerBuilder advanced() {
            return (AdvancedIronMQEndpointConsumerBuilder) this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option is a: <code>io.iron.ironmq.Client</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointConsumerBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option will be converted to a <code>io.iron.ironmq.Client</code>
         * type.
         * 
         * Group: common
         */
        default IronMQEndpointConsumerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * IronMq Cloud url. Urls for public clusters:
         * https://mq-aws-us-east-1-1.iron.io (US) and
         * https://mq-aws-eu-west-1-1.iron.io (EU).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://mq-aws-us-east-1-1.iron.io
         * Group: common
         */
        default IronMQEndpointConsumerBuilder ironMQCloud(String ironMQCloud) {
            doSetProperty("ironMQCloud", ironMQCloud);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointConsumerBuilder preserveHeaders(
                boolean preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointConsumerBuilder preserveHeaders(
                String preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * IronMQ projectId.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointConsumerBuilder projectId(String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
        /**
         * IronMQ token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointConsumerBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * Should messages be deleted in one batch. This will limit the number
         * of api requests since messages are deleted in one request, instead of
         * one pr. exchange. If enabled care should be taken that the consumer
         * is idempotent when processing exchanges.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder batchDelete(boolean batchDelete) {
            doSetProperty("batchDelete", batchDelete);
            return this;
        }
        /**
         * Should messages be deleted in one batch. This will limit the number
         * of api requests since messages are deleted in one request, instead of
         * one pr. exchange. If enabled care should be taken that the consumer
         * is idempotent when processing exchanges.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder batchDelete(String batchDelete) {
            doSetProperty("batchDelete", batchDelete);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The number of concurrent consumers.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The number of concurrent consumers.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Number of messages to poll pr. call. Maximum is 100.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Number of messages to poll pr. call. Maximum is 100.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * After timeout (in seconds), item will be placed back onto the queue.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * After timeout (in seconds), item will be placed back onto the queue.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Time in seconds to wait for a message to become available. This
         * enables long polling. Default is 0 (does not wait), maximum is 30.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder wait(int wait) {
            doSetProperty("wait", wait);
            return this;
        }
        /**
         * Time in seconds to wait for a message to become available. This
         * enables long polling. Default is 0 (does not wait), maximum is 30.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default IronMQEndpointConsumerBuilder wait(String wait) {
            doSetProperty("wait", wait);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default IronMQEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IronMQ component.
     */
    public interface AdvancedIronMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default IronMQEndpointConsumerBuilder basic() {
            return (IronMQEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIronMQEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IronMQ component.
     */
    public interface IronMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIronMQEndpointProducerBuilder advanced() {
            return (AdvancedIronMQEndpointProducerBuilder) this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option is a: <code>io.iron.ironmq.Client</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointProducerBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option will be converted to a <code>io.iron.ironmq.Client</code>
         * type.
         * 
         * Group: common
         */
        default IronMQEndpointProducerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * IronMq Cloud url. Urls for public clusters:
         * https://mq-aws-us-east-1-1.iron.io (US) and
         * https://mq-aws-eu-west-1-1.iron.io (EU).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://mq-aws-us-east-1-1.iron.io
         * Group: common
         */
        default IronMQEndpointProducerBuilder ironMQCloud(String ironMQCloud) {
            doSetProperty("ironMQCloud", ironMQCloud);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointProducerBuilder preserveHeaders(
                boolean preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointProducerBuilder preserveHeaders(
                String preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * IronMQ projectId.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointProducerBuilder projectId(String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
        /**
         * IronMQ token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointProducerBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default IronMQEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default IronMQEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The item will not be available on the queue until this many seconds
         * have passed. Default is 0 seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default IronMQEndpointProducerBuilder visibilityDelay(
                int visibilityDelay) {
            doSetProperty("visibilityDelay", visibilityDelay);
            return this;
        }
        /**
         * The item will not be available on the queue until this many seconds
         * have passed. Default is 0 seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default IronMQEndpointProducerBuilder visibilityDelay(
                String visibilityDelay) {
            doSetProperty("visibilityDelay", visibilityDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IronMQ component.
     */
    public interface AdvancedIronMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default IronMQEndpointProducerBuilder basic() {
            return (IronMQEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IronMQ component.
     */
    public interface IronMQEndpointBuilder
            extends
                IronMQEndpointConsumerBuilder,
                IronMQEndpointProducerBuilder {
        default AdvancedIronMQEndpointBuilder advanced() {
            return (AdvancedIronMQEndpointBuilder) this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option is a: <code>io.iron.ironmq.Client</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Reference to a io.iron.ironmq.Client in the Registry.
         * 
         * The option will be converted to a <code>io.iron.ironmq.Client</code>
         * type.
         * 
         * Group: common
         */
        default IronMQEndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * IronMq Cloud url. Urls for public clusters:
         * https://mq-aws-us-east-1-1.iron.io (US) and
         * https://mq-aws-eu-west-1-1.iron.io (EU).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://mq-aws-us-east-1-1.iron.io
         * Group: common
         */
        default IronMQEndpointBuilder ironMQCloud(String ironMQCloud) {
            doSetProperty("ironMQCloud", ironMQCloud);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointBuilder preserveHeaders(boolean preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * Should message headers be preserved when publishing messages. This
         * will add the Camel headers to the Iron MQ message as a json payload
         * with a header list, and a message body. Useful when Camel is both
         * consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default IronMQEndpointBuilder preserveHeaders(String preserveHeaders) {
            doSetProperty("preserveHeaders", preserveHeaders);
            return this;
        }
        /**
         * IronMQ projectId.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointBuilder projectId(String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
        /**
         * IronMQ token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IronMQEndpointBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IronMQ component.
     */
    public interface AdvancedIronMQEndpointBuilder
            extends
                AdvancedIronMQEndpointConsumerBuilder,
                AdvancedIronMQEndpointProducerBuilder {
        default IronMQEndpointBuilder basic() {
            return (IronMQEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedIronMQEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface IronMQBuilders {
        /**
         * IronMQ (camel-ironmq)
         * The ironmq provides integration with IronMQ an elastic and durable
         * hosted message queue as a service.
         * 
         * Category: cloud,messaging
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-ironmq
         * 
         * Syntax: <code>ironmq:queueName</code>
         * 
         * Path parameter: queueName (required)
         * The name of the IronMQ queue
         */
        default IronMQEndpointBuilder ironmq(String path) {
            return IronMQEndpointBuilderFactory.ironmq(path);
        }
    }
    /**
     * IronMQ (camel-ironmq)
     * The ironmq provides integration with IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     * 
     * Syntax: <code>ironmq:queueName</code>
     * 
     * Path parameter: queueName (required)
     * The name of the IronMQ queue
     */
    static IronMQEndpointBuilder ironmq(String path) {
        class IronMQEndpointBuilderImpl extends AbstractEndpointBuilder implements IronMQEndpointBuilder, AdvancedIronMQEndpointBuilder {
            public IronMQEndpointBuilderImpl(String path) {
                super("ironmq", path);
            }
        }
        return new IronMQEndpointBuilderImpl(path);
    }
}