/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

public interface SdbEndpointBuilderFactory {
    public static SdbEndpointBuilder awsSdb(String path) {
        class SdbEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements SdbEndpointBuilder,
        AdvancedSdbEndpointBuilder {
            public SdbEndpointBuilderImpl(String path) {
                super("aws-sdb", path);
            }
        }
        return new SdbEndpointBuilderImpl(path);
    }

    public static interface SdbBuilders {
        default public SdbEndpointBuilder awsSdb(String path) {
            return SdbEndpointBuilderFactory.awsSdb(path);
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum SdbOperations {
        BatchDeleteAttributes,
        BatchPutAttributes,
        DeleteAttributes,
        DeleteDomain,
        DomainMetadata,
        GetAttributes,
        ListDomains,
        PutAttributes,
        Select;

    }

    public static interface AdvancedSdbEndpointBuilder
    extends EndpointProducerBuilder {
        default public SdbEndpointBuilder basic() {
            return (SdbEndpointBuilder)((Object)this);
        }

        default public AdvancedSdbEndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedSdbEndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedSdbEndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedSdbEndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface SdbEndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedSdbEndpointBuilder advanced() {
            return (AdvancedSdbEndpointBuilder)((Object)this);
        }

        default public SdbEndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public SdbEndpointBuilder amazonSDBClient(Object amazonSDBClient) {
            this.doSetProperty("amazonSDBClient", amazonSDBClient);
            return this;
        }

        default public SdbEndpointBuilder amazonSDBClient(String amazonSDBClient) {
            this.doSetProperty("amazonSDBClient", amazonSDBClient);
            return this;
        }

        default public SdbEndpointBuilder consistentRead(boolean consistentRead) {
            this.doSetProperty("consistentRead", consistentRead);
            return this;
        }

        default public SdbEndpointBuilder consistentRead(String consistentRead) {
            this.doSetProperty("consistentRead", consistentRead);
            return this;
        }

        default public SdbEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SdbEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SdbEndpointBuilder maxNumberOfDomains(Integer maxNumberOfDomains) {
            this.doSetProperty("maxNumberOfDomains", maxNumberOfDomains);
            return this;
        }

        default public SdbEndpointBuilder maxNumberOfDomains(String maxNumberOfDomains) {
            this.doSetProperty("maxNumberOfDomains", maxNumberOfDomains);
            return this;
        }

        default public SdbEndpointBuilder operation(SdbOperations operation) {
            this.doSetProperty("operation", (Object)operation);
            return this;
        }

        default public SdbEndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public SdbEndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public SdbEndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public SdbEndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public SdbEndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public SdbEndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public SdbEndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public SdbEndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

