/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Send requests to external HTTP servers using Apache HTTP Client 4.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface HttpEndpointBuilderFactory {


    /**
     * Builder for endpoint for the HTTP component.
     */
    public interface HttpEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedHttpEndpointBuilder advanced() {
            return (AdvancedHttpEndpointBuilder) this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default HttpEndpointBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default HttpEndpointBuilder disableStreamCache(String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default HttpEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default HttpEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder clearExpiredCookies(
                boolean clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder clearExpiredCookies(
                String clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder connectionClose(boolean connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder connectionClose(String connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder copyHeaders(boolean copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder copyHeaders(String copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * To use custom host header for producer. When not set in query will be
         * ignored. When set will override host header derived from url.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default HttpEndpointBuilder customHostHeader(String customHostHeader) {
            doSetProperty("customHostHeader", customHostHeader);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         */
        default HttpEndpointBuilder httpMethod(HttpMethods httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         */
        default HttpEndpointBuilder httpMethod(String httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder ignoreResponseBody(
                boolean ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder ignoreResponseBody(String ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder preserveHostHeader(
                boolean preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder preserveHostHeader(String preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HttpEndpointBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HttpEndpointBuilder transferException(String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Proxy authentication domain to use with NTML.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthDomain(String proxyAuthDomain) {
            doSetProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
        /**
         * Proxy authentication host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthHost(String proxyAuthHost) {
            doSetProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
        /**
         * Proxy authentication method to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthMethod(String proxyAuthMethod) {
            doSetProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
        /**
         * Proxy authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthPassword(String proxyAuthPassword) {
            doSetProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
        /**
         * Proxy authentication port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthPort(int proxyAuthPort) {
            doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }
        /**
         * Proxy authentication port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthPort(String proxyAuthPort) {
            doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }
        /**
         * Proxy authentication scheme to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthScheme(String proxyAuthScheme) {
            doSetProperty("proxyAuthScheme", proxyAuthScheme);
            return this;
        }
        /**
         * Proxy authentication username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyAuthUsername(String proxyAuthUsername) {
            doSetProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
        /**
         * Proxy hostname to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy port to use.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyPort(int proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy port to use.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         */
        default HttpEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Authentication domain to use with NTML.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authDomain(String authDomain) {
            doSetProperty("authDomain", authDomain);
            return this;
        }
        /**
         * If this option is true, camel-http sends preemptive basic
         * authentication to the server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default HttpEndpointBuilder authenticationPreemptive(
                boolean authenticationPreemptive) {
            doSetProperty("authenticationPreemptive", authenticationPreemptive);
            return this;
        }
        /**
         * If this option is true, camel-http sends preemptive basic
         * authentication to the server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default HttpEndpointBuilder authenticationPreemptive(
                String authenticationPreemptive) {
            doSetProperty("authenticationPreemptive", authenticationPreemptive);
            return this;
        }
        /**
         * Authentication host to use with NTML.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authHost(String authHost) {
            doSetProperty("authHost", authHost);
            return this;
        }
        /**
         * Authentication methods allowed to use as a comma separated list of
         * values Basic, Digest or NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authMethod(String authMethod) {
            doSetProperty("authMethod", authMethod);
            return this;
        }
        /**
         * Which authentication method to prioritize to use, either as Basic,
         * Digest or NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authMethodPriority(String authMethodPriority) {
            doSetProperty("authMethodPriority", authMethodPriority);
            return this;
        }
        /**
         * Authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authPassword(String authPassword) {
            doSetProperty("authPassword", authPassword);
            return this;
        }
        /**
         * Authentication username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder authUsername(String authUsername) {
            doSetProperty("authUsername", authUsername);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. Important: Only one
         * instance of org.apache.camel.util.jsse.SSLContextParameters is
         * supported per HttpComponent. If you need to use 2 or more different
         * instances, you need to define a new HttpComponent per instance you
         * need.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. Important: Only one
         * instance of org.apache.camel.util.jsse.SSLContextParameters is
         * supported per HttpComponent. If you need to use 2 or more different
         * instances, you need to define a new HttpComponent per instance you
         * need.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To use a custom X509HostnameVerifier such as DefaultHostnameVerifier
         * or NoopHostnameVerifier.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder x509HostnameVerifier(
                Object x509HostnameVerifier) {
            doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }
        /**
         * To use a custom X509HostnameVerifier such as DefaultHostnameVerifier
         * or NoopHostnameVerifier.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         */
        default HttpEndpointBuilder x509HostnameVerifier(
                String x509HostnameVerifier) {
            doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the HTTP component.
     */
    public interface AdvancedHttpEndpointBuilder
            extends
                EndpointProducerBuilder {
        default HttpEndpointBuilder basic() {
            return (HttpEndpointBuilder) this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.HttpBinding</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedHttpEndpointBuilder httpBinding(Object httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.HttpBinding</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedHttpEndpointBuilder httpBinding(String httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder cookieHandler(Object cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder cookieHandler(String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * To use a custom CookieStore. By default the BasicCookieStore is used
         * which is an in-memory only cookie store. Notice if
         * bridgeEndpoint=true then the cookie store is forced to be a noop
         * cookie store as cookie shouldn't be stored as we are just bridging
         * (eg acting as a proxy). If a cookieHandler is set then the cookie
         * store is also forced to be a noop cookie store as cookie handling is
         * then performed by the cookieHandler.
         * 
         * The option is a: <code>org.apache.http.client.CookieStore</code>
         * type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder cookieStore(Object cookieStore) {
            doSetProperty("cookieStore", cookieStore);
            return this;
        }
        /**
         * To use a custom CookieStore. By default the BasicCookieStore is used
         * which is an in-memory only cookie store. Notice if
         * bridgeEndpoint=true then the cookie store is forced to be a noop
         * cookie store as cookie shouldn't be stored as we are just bridging
         * (eg acting as a proxy). If a cookieHandler is set then the cookie
         * store is also forced to be a noop cookie store as cookie handling is
         * then performed by the cookieHandler.
         * 
         * The option will be converted to a
         * <code>org.apache.http.client.CookieStore</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder cookieStore(String cookieStore) {
            doSetProperty("cookieStore", cookieStore);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder deleteWithBody(
                boolean deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder deleteWithBody(String deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder getWithBody(boolean getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder getWithBody(String getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * The status codes which are considered a success response. The values
         * are inclusive. Multiple ranges can be defined, separated by comma,
         * e.g. 200-204,209,301-304. Each range must be a single number or
         * from-to with the dash included.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 200-299
         * Group: producer (advanced)
         */
        default AdvancedHttpEndpointBuilder okStatusCodeRange(
                String okStatusCodeRange) {
            doSetProperty("okStatusCodeRange", okStatusCodeRange);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Provide access to the http client request parameters used on new
         * RequestConfig instances used by producers or consumers of this
         * endpoint.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder clientBuilder(Object clientBuilder) {
            doSetProperty("clientBuilder", clientBuilder);
            return this;
        }
        /**
         * Provide access to the http client request parameters used on new
         * RequestConfig instances used by producers or consumers of this
         * endpoint.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder clientBuilder(String clientBuilder) {
            doSetProperty("clientBuilder", clientBuilder);
            return this;
        }
        /**
         * To use a custom HttpClientConnectionManager to manage connections.
         * 
         * The option is a:
         * <code>org.apache.http.conn.HttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder clientConnectionManager(
                Object clientConnectionManager) {
            doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }
        /**
         * To use a custom HttpClientConnectionManager to manage connections.
         * 
         * The option will be converted to a
         * <code>org.apache.http.conn.HttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder clientConnectionManager(
                String clientConnectionManager) {
            doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }
        /**
         * The maximum number of connections per route.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 20
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder connectionsPerRoute(
                int connectionsPerRoute) {
            doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }
        /**
         * The maximum number of connections per route.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 20
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder connectionsPerRoute(
                String connectionsPerRoute) {
            doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }
        /**
         * Sets a custom HttpClient to be used by the producer.
         * 
         * The option is a: <code>org.apache.http.client.HttpClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClient(Object httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Sets a custom HttpClient to be used by the producer.
         * 
         * The option will be converted to a
         * <code>org.apache.http.client.HttpClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Register a custom configuration strategy for new HttpClient instances
         * created by producers or consumers such as to configure authentication
         * mechanisms etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.http.HttpClientConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClientConfigurer(
                Object httpClientConfigurer) {
            doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }
        /**
         * Register a custom configuration strategy for new HttpClient instances
         * created by producers or consumers such as to configure authentication
         * mechanisms etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.http.HttpClientConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClientConfigurer(
                String httpClientConfigurer) {
            doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }
        /**
         * To configure the HttpClient using the key/values from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpClientOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClientOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("httpClientOptions", "httpClient." + key, value);
            return this;
        }
        /**
         * To configure the HttpClient using the key/values from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpClientOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpClientOptions(Map values) {
            doSetMultiValueProperties("httpClientOptions", "httpClient.", values);
            return this;
        }
        /**
         * To use a custom HttpContext instance.
         * 
         * The option is a: <code>org.apache.http.protocol.HttpContext</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpContext(Object httpContext) {
            doSetProperty("httpContext", httpContext);
            return this;
        }
        /**
         * To use a custom HttpContext instance.
         * 
         * The option will be converted to a
         * <code>org.apache.http.protocol.HttpContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder httpContext(String httpContext) {
            doSetProperty("httpContext", httpContext);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * The maximum number of connections.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 200
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder maxTotalConnections(
                int maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * The maximum number of connections.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 200
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder useSystemProperties(
                boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHttpEndpointBuilder useSystemProperties(
                String useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    }

    /**
     * Proxy enum for <code>org.apache.camel.http.common.HttpMethods</code>
     * enum.
     */
    enum HttpMethods {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        PATCH;
    }

    public interface HttpBuilders {
        /**
         * HTTP (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 4.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>http:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         */
        default HttpEndpointBuilder http(String path) {
            return HttpEndpointBuilderFactory.endpointBuilder("http", path);
        }
        /**
         * HTTP (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 4.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>http:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         */
        default HttpEndpointBuilder http(String componentName, String path) {
            return HttpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * HTTPS (Secure) (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 4.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>https:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         */
        default HttpEndpointBuilder https(String path) {
            return HttpEndpointBuilderFactory.endpointBuilder("https", path);
        }
    }
    static HttpEndpointBuilder endpointBuilder(String componentName, String path) {
        class HttpEndpointBuilderImpl extends AbstractEndpointBuilder implements HttpEndpointBuilder, AdvancedHttpEndpointBuilder {
            public HttpEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new HttpEndpointBuilderImpl(path);
    }
}