/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.athena.Athena2Operations;
import org.apache.camel.component.aws2.athena.Athena2OutputType;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.EncryptionOption;

public interface Athena2EndpointBuilderFactory {
    public static Athena2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Athena2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Athena2EndpointBuilder,
        AdvancedAthena2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public Athena2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new Athena2EndpointBuilderImpl(path, componentName);
    }

    public static class Athena2HeaderNameBuilder {
        private static final Athena2HeaderNameBuilder INSTANCE = new Athena2HeaderNameBuilder();

        public String awsAthenaOperation() {
            return "CamelAwsAthenaOperation";
        }

        public String awsAthenaDatabase() {
            return "CamelAwsAthenaDatabase";
        }

        public String awsAthenaQueryExecutionId() {
            return "CamelAwsAthenaQueryExecutionId";
        }

        public String awsAthenaWorkGroup() {
            return "CamelAwsAthenaWorkGroup";
        }

        public String awsAthenaNextToken() {
            return "CamelAwsAthenaNextToken";
        }

        public String awsAthenaMaxResults() {
            return "CamelAwsAthenaMaxResults";
        }

        public String awsAthenaIncludeTrace() {
            return "CamelAwsAthenaIncludeTrace";
        }

        public String awsAthenaOutputLocation() {
            return "CamelAwsAthenaOutputLocation";
        }

        public String awsAthenaOutputType() {
            return "CamelAwsAthenaOutputType";
        }

        public String awsAthenaQueryExecutionState() {
            return "CamelAwsAthenaQueryExecutionState";
        }

        public String awsAthenaClientRequestToken() {
            return "CamelAwsAthenaClientRequestToken";
        }

        public String awsAthenaQueryString() {
            return "CamelAwsAthenaQueryString";
        }

        public String awsAthenaEncryptionOption() {
            return "CamelAwsAthenaEncryptionOption";
        }

        public String awsAthenaKmsKey() {
            return "CamelAwsAthenaKmsKey";
        }

        public String awsAthenaWaitTimeout() {
            return "CamelAwsAthenaWaitTimeout";
        }

        public String awsAthenaInitialDelay() {
            return "CamelAwsAthenaInitialDelay";
        }

        public String awsAthenaDelay() {
            return "CamelAwsAthenaDelay";
        }

        public String awsAthenaMaxAttempts() {
            return "CamelAwsAthenaMaxAttempts";
        }

        public String awsAthenaRetry() {
            return "CamelAwsAthenaRetry";
        }

        public String awsAthenaResetWaitTimeoutOnRetry() {
            return "CamelAwsAthenaResetWaitTimeoutOnRetry";
        }

        public String awsAthenaStartQueryExecutionAttempts() {
            return "CamelAwsAthenaStartQueryExecutionAttempts";
        }

        public String awsAthenaStartQueryExecutionElapsedMillis() {
            return "CamelAwsAthenaStartQueryExecutionElapsedMillis";
        }
    }

    public static interface Athena2Builders {
        default public Athena2HeaderNameBuilder aws2Athena() {
            return Athena2HeaderNameBuilder.INSTANCE;
        }

        default public Athena2EndpointBuilder aws2Athena(String path) {
            return Athena2EndpointBuilderFactory.endpointBuilder("aws2-athena", path);
        }

        default public Athena2EndpointBuilder aws2Athena(String componentName, String path) {
            return Athena2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedAthena2EndpointBuilder
    extends EndpointProducerBuilder {
        default public Athena2EndpointBuilder basic() {
            return (Athena2EndpointBuilder)((Object)this);
        }

        default public AdvancedAthena2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder amazonAthenaClient(AthenaClient amazonAthenaClient) {
            this.doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder amazonAthenaClient(String amazonAthenaClient) {
            this.doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder clientRequestToken(String clientRequestToken) {
            this.doSetProperty("clientRequestToken", clientRequestToken);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder includeTrace(boolean includeTrace) {
            this.doSetProperty("includeTrace", includeTrace);
            return this;
        }

        default public AdvancedAthena2EndpointBuilder includeTrace(String includeTrace) {
            this.doSetProperty("includeTrace", includeTrace);
            return this;
        }
    }

    public static interface Athena2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedAthena2EndpointBuilder advanced() {
            return (AdvancedAthena2EndpointBuilder)((Object)this);
        }

        default public Athena2EndpointBuilder database(String database) {
            this.doSetProperty("database", database);
            return this;
        }

        default public Athena2EndpointBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public Athena2EndpointBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public Athena2EndpointBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public Athena2EndpointBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public Athena2EndpointBuilder maxAttempts(int maxAttempts) {
            this.doSetProperty("maxAttempts", maxAttempts);
            return this;
        }

        default public Athena2EndpointBuilder maxAttempts(String maxAttempts) {
            this.doSetProperty("maxAttempts", maxAttempts);
            return this;
        }

        default public Athena2EndpointBuilder maxResults(Integer maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public Athena2EndpointBuilder maxResults(String maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public Athena2EndpointBuilder nextToken(String nextToken) {
            this.doSetProperty("nextToken", nextToken);
            return this;
        }

        default public Athena2EndpointBuilder operation(Athena2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Athena2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Athena2EndpointBuilder outputLocation(String outputLocation) {
            this.doSetProperty("outputLocation", outputLocation);
            return this;
        }

        default public Athena2EndpointBuilder outputType(Athena2OutputType outputType) {
            this.doSetProperty("outputType", outputType);
            return this;
        }

        default public Athena2EndpointBuilder outputType(String outputType) {
            this.doSetProperty("outputType", outputType);
            return this;
        }

        default public Athena2EndpointBuilder queryExecutionId(String queryExecutionId) {
            this.doSetProperty("queryExecutionId", queryExecutionId);
            return this;
        }

        default public Athena2EndpointBuilder queryString(String queryString) {
            this.doSetProperty("queryString", queryString);
            return this;
        }

        default public Athena2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Athena2EndpointBuilder resetWaitTimeoutOnRetry(boolean resetWaitTimeoutOnRetry) {
            this.doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }

        default public Athena2EndpointBuilder resetWaitTimeoutOnRetry(String resetWaitTimeoutOnRetry) {
            this.doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }

        default public Athena2EndpointBuilder retry(String retry) {
            this.doSetProperty("retry", retry);
            return this;
        }

        default public Athena2EndpointBuilder waitTimeout(long waitTimeout) {
            this.doSetProperty("waitTimeout", waitTimeout);
            return this;
        }

        default public Athena2EndpointBuilder waitTimeout(String waitTimeout) {
            this.doSetProperty("waitTimeout", waitTimeout);
            return this;
        }

        default public Athena2EndpointBuilder workGroup(String workGroup) {
            this.doSetProperty("workGroup", workGroup);
            return this;
        }

        default public Athena2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Athena2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Athena2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Athena2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Athena2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Athena2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Athena2EndpointBuilder encryptionOption(EncryptionOption encryptionOption) {
            this.doSetProperty("encryptionOption", encryptionOption);
            return this;
        }

        default public Athena2EndpointBuilder encryptionOption(String encryptionOption) {
            this.doSetProperty("encryptionOption", encryptionOption);
            return this;
        }

        default public Athena2EndpointBuilder kmsKey(String kmsKey) {
            this.doSetProperty("kmsKey", kmsKey);
            return this;
        }

        default public Athena2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Athena2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Athena2EndpointBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Athena2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Athena2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Athena2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Athena2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Athena2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public Athena2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

