/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileRenameExclusiveReadLockStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIdempotentRenameRepositoryReadLockStrategy
extends ServiceSupport
implements GenericFileExclusiveReadLockStrategy<File>,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FileIdempotentRenameRepositoryReadLockStrategy.class);
    private final FileRenameExclusiveReadLockStrategy rename;
    private GenericFileEndpoint<File> endpoint;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;
    private CamelContext camelContext;
    private IdempotentRepository idempotentRepository;
    private boolean removeOnRollback = true;
    private boolean removeOnCommit;

    public FileIdempotentRenameRepositoryReadLockStrategy() {
        this.rename = new FileRenameExclusiveReadLockStrategy();
        this.rename.setMarkerFiler(false);
        this.rename.setDeleteOrphanLockFiles(false);
    }

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) throws Exception {
        this.endpoint = endpoint;
        LOG.info("Using FileIdempotentRepositoryReadLockStrategy: {} on endpoint: {}", (Object)this.idempotentRepository, endpoint);
        this.rename.prepareOnStartup(operations, endpoint);
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        boolean answer;
        String key;
        block5: {
            File path = file.getFile();
            if (!path.exists()) {
                return false;
            }
            key = this.asKey(file);
            answer = false;
            try {
                answer = this.idempotentRepository.add(exchange, key);
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace("Cannot acquire read lock due to " + e.getMessage() + ". Will skip the file: " + file, (Throwable)e);
            }
        }
        if (!answer) {
            CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock. Will skip the file: " + file));
        }
        if (answer && !(answer = this.rename.acquireExclusiveReadLock(operations, file, exchange))) {
            this.idempotentRepository.remove(exchange, key);
        }
        return answer;
    }

    @Override
    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.rename.releaseExclusiveReadLockOnAbort(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        if (this.removeOnRollback) {
            this.idempotentRepository.remove(exchange, key);
        } else {
            this.idempotentRepository.confirm(exchange, key);
        }
        this.rename.releaseExclusiveReadLockOnRollback(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        if (this.removeOnCommit) {
            this.idempotentRepository.remove(exchange, key);
        } else {
            this.idempotentRepository.confirm(exchange, key);
        }
        this.rename.releaseExclusiveReadLockOnCommit(operations, file, exchange);
    }

    @Override
    public void setTimeout(long timeout) {
        this.rename.setTimeout(timeout);
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.rename.setCheckInterval(checkInterval);
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
        this.rename.setReadLockLoggingLevel(readLockLoggingLevel);
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
    }

    @Override
    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public boolean isRemoveOnRollback() {
        return this.removeOnRollback;
    }

    public void setRemoveOnRollback(boolean removeOnRollback) {
        this.removeOnRollback = removeOnRollback;
    }

    public boolean isRemoveOnCommit() {
        return this.removeOnCommit;
    }

    public void setRemoveOnCommit(boolean removeOnCommit) {
        this.removeOnCommit = removeOnCommit;
    }

    protected String asKey(GenericFile<File> file) {
        String key = file.getAbsoluteFilePath();
        if (this.endpoint.getIdempotentKey() != null) {
            Exchange dummy = this.endpoint.createExchange(file);
            key = (String)this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
        }
        return key;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)this);
        ObjectHelper.notNull((Object)this.idempotentRepository, (String)"idempotentRepository", (Object)this);
        this.camelContext.addService((Object)this.idempotentRepository, true);
    }

    protected void doStop() throws Exception {
    }
}

