/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class HttpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = "://httpUri";
    private static final String[] SCHEMES = new String[]{"http", "https"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(49);
        props.add("authDomain");
        props.add("authHost");
        props.add("authMethod");
        props.add("authMethodPriority");
        props.add("authPassword");
        props.add("authUsername");
        props.add("authenticationPreemptive");
        props.add("bridgeEndpoint");
        props.add("clearExpiredCookies");
        props.add("clientBuilder");
        props.add("clientConnectionManager");
        props.add("connectionClose");
        props.add("connectionsPerRoute");
        props.add("cookieHandler");
        props.add("cookieStore");
        props.add("copyHeaders");
        props.add("customHostHeader");
        props.add("deleteWithBody");
        props.add("disableStreamCache");
        props.add("getWithBody");
        props.add("headerFilterStrategy");
        props.add("httpClient");
        props.add("httpClientConfigurer");
        props.add("httpClientOptions");
        props.add("httpContext");
        props.add("httpMethod");
        props.add("httpUri");
        props.add("ignoreResponseBody");
        props.add("lazyStartProducer");
        props.add("maxTotalConnections");
        props.add("okStatusCodeRange");
        props.add("preserveHostHeader");
        props.add("proxyAuthDomain");
        props.add("proxyAuthHost");
        props.add("proxyAuthMethod");
        props.add("proxyAuthNtHost");
        props.add("proxyAuthPassword");
        props.add("proxyAuthPort");
        props.add("proxyAuthScheme");
        props.add("proxyAuthUsername");
        props.add("proxyHost");
        props.add("proxyPort");
        props.add("skipRequestHeaders");
        props.add("skipResponseHeaders");
        props.add("sslContextParameters");
        props.add("throwExceptionOnFailure");
        props.add("useSystemProperties");
        props.add("userAgent");
        props.add("x509HostnameVerifier");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("authPassword");
        secretProps.add("authUsername");
        secretProps.add("proxyAuthPassword");
        secretProps.add("proxyAuthUsername");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("httpClient.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

