/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.transform;

import com.fasterxml.jackson.core.FormatSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.SchemaType;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.MimeType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="application-x-java-object", description="Transforms from JSon to Java object using Jackson (supports content schema)")
public class JsonPojoDataTypeTransformer
extends Transformer
implements CamelContextAware {
    private CamelContext camelContext;

    public void transform(Message message, DataType fromType, DataType toType) {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        FormatSchema schema = (FormatSchema)message.getExchange().getProperty("X-Content-Schema", FormatSchema.class);
        String contentClass = SchemaHelper.resolveContentClass(message.getExchange(), null);
        if (contentClass == null) {
            throw new CamelExecutionException("Missing content class information for Java object data type processing", message.getExchange());
        }
        SchemaType schemaType = SchemaType.of((String)message.getExchange().getProperty("X-Content-Schema-Type", (Object)Optional.ofNullable(schema).map(FormatSchema::getSchemaType).orElse(SchemaType.JSON.name()), String.class));
        try {
            message.setHeader("Content-Type", (Object)MimeType.JAVA_OBJECT.type());
            Class contentType = this.camelContext.getClassResolver().resolveMandatoryClass(contentClass);
            if (contentType.isAssignableFrom(message.getBody().getClass())) {
                return;
            }
            message.setBody(this.getJavaObject(message, schemaType, schema, contentType));
        }
        catch (IOException | ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Java object data type on exchange", message.getExchange(), e);
        }
    }

    protected Object getJavaObject(Message message, SchemaType schemaType, FormatSchema schema, Class<?> contentType) throws InvalidPayloadException, IOException {
        if (schemaType == SchemaType.JSON) {
            return Json.mapper().reader().forType(contentType).readValue(this.getBodyAsStream(message));
        }
        throw new CamelExecutionException(String.format("Unsupported schema type '%s'", new Object[]{schemaType}), message.getExchange());
    }

    protected InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

