/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.JaxbHelper;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackTypeConverter
extends ServiceSupport
implements TypeConverter,
TypeConverterAware,
CamelContextAware {
    public static final String PRETTY_PRINT = "CamelJaxbPrettyPrint";
    public static final String OBJECT_FACTORY = "CamelJaxbObjectFactory";
    private static final Logger LOG = LoggerFactory.getLogger(FallbackTypeConverter.class);
    private final Map<AnnotatedElement, JAXBContext> contexts = new HashMap<AnnotatedElement, JAXBContext>();
    private final StaxConverter staxConverter = new StaxConverter();
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;
    private boolean objectFactory;
    private CamelContext camelContext;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(boolean objectFactory) {
        this.objectFactory = objectFactory;
    }

    public boolean allowNull() {
        return false;
    }

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        if (camelContext != null) {
            String property = camelContext.getProperty(PRETTY_PRINT);
            if (property != null) {
                if (property.equalsIgnoreCase("false")) {
                    this.setPrettyPrint(false);
                } else {
                    this.setPrettyPrint(true);
                }
            }
            if ((property = camelContext.getProperty(OBJECT_FACTORY)) != null) {
                if (property.equalsIgnoreCase("false")) {
                    this.setObjectFactory(false);
                } else {
                    this.setObjectFactory(true);
                }
            }
        }
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (BeanInvocation.class.isAssignableFrom(type) || Processor.class.isAssignableFrom(type)) {
            return null;
        }
        try {
            if (this.isJaxbType(type)) {
                return this.unmarshall(type, exchange, value);
            }
            if (value != null && FallbackTypeConverter.isNotStreamCacheType(type)) {
                CamelContext context;
                Method objectFactoryMethod;
                if (this.hasXmlRootElement(value.getClass())) {
                    return this.marshall(type, exchange, value, null);
                }
                if (this.isObjectFactory() && (objectFactoryMethod = JaxbHelper.getJaxbElementFactoryMethod(context = exchange != null ? exchange.getContext() : this.camelContext, value.getClass())) != null) {
                    return this.marshall(type, exchange, value, objectFactoryMethod);
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException(value, type, (Throwable)e);
        }
        return null;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        T answer = this.convertTo(type, exchange, value);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, null, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, exchange, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void doStart() throws Exception {
        LOG.info("Jaxb FallbackTypeConverter[prettyPrint={}, objectFactory={}]", (Object)this.prettyPrint, (Object)this.objectFactory);
    }

    protected void doStop() throws Exception {
        this.contexts.clear();
    }

    private <T> boolean hasXmlRootElement(Class<T> type) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    protected <T> boolean isJaxbType(Class<T> type) {
        if (this.isObjectFactory()) {
            return this.hasXmlRootElement(type) || JaxbHelper.getJaxbElementFactoryMethod(this.camelContext, type) != null;
        }
        return this.hasXmlRootElement(type);
    }

    private <T> T castJaxbType(Object o, Class<T> type) {
        if (type.isAssignableFrom(o.getClass())) {
            return type.cast(o);
        }
        return type.cast(((JAXBElement)o).getValue());
    }

    protected <T> T unmarshall(Class<T> type, Exchange exchange, Object value) throws Exception {
        LOG.trace("Unmarshal to {} with value {}", type, value);
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        Unmarshaller unmarshaller = this.getUnmarshaller(type);
        if (this.parentTypeConverter != null) {
            InputStream inputStream;
            XMLStreamReader xmlReader;
            if (!this.needFiltering(exchange) && (xmlReader = (XMLStreamReader)this.parentTypeConverter.convertTo(XMLStreamReader.class, exchange, value)) != null) {
                try {
                    Object unmarshalled = this.unmarshal(unmarshaller, exchange, xmlReader);
                    return this.castJaxbType(unmarshalled, type);
                }
                catch (Exception ex) {
                    LOG.debug("Cannot use StaxStreamReader to unmarshal the message, due to {}", (Throwable)ex);
                }
            }
            if ((inputStream = (InputStream)this.parentTypeConverter.convertTo(InputStream.class, exchange, value)) != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, inputStream);
                return this.castJaxbType(unmarshalled, type);
            }
            Reader reader = (Reader)this.parentTypeConverter.convertTo(Reader.class, exchange, value);
            if (reader != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, reader);
                return this.castJaxbType(unmarshalled, type);
            }
            Source source = (Source)this.parentTypeConverter.convertTo(Source.class, exchange, value);
            if (source != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, source);
                return this.castJaxbType(unmarshalled, type);
            }
        }
        if (value instanceof String) {
            value = new StringReader((String)value);
        }
        if (value instanceof InputStream || value instanceof Reader) {
            Object unmarshalled = this.unmarshal(unmarshaller, exchange, value);
            return this.castJaxbType(unmarshalled, type);
        }
        return null;
    }

    protected <T> T marshall(Class<T> type, Exchange exchange, Object value, Method objectFactoryMethod) throws JAXBException, XMLStreamException, FactoryConfigurationError, TypeConversionException {
        LOG.trace("Marshal from value {} to type {}", value, type);
        Object answer = null;
        if (this.parentTypeConverter != null) {
            JAXBContext context = this.createContext(value.getClass());
            Marshaller marshaller = context.createMarshaller();
            StringWriter buffer = new StringWriter();
            if (this.isPrettyPrint()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if (exchange != null && exchange.getProperty("CamelCharsetName", String.class) != null) {
                marshaller.setProperty("jaxb.encoding", exchange.getProperty("CamelCharsetName", String.class));
            }
            Object toMarshall = value;
            if (objectFactoryMethod != null) {
                try {
                    Object instance = objectFactoryMethod.getDeclaringClass().newInstance();
                    if (instance != null) {
                        toMarshall = objectFactoryMethod.invoke(instance, value);
                    }
                }
                catch (Exception e) {
                    LOG.debug("Unable to create JAXBElement object for type " + value.getClass() + " due to " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.needFiltering(exchange)) {
                XMLStreamWriter writer = (XMLStreamWriter)this.parentTypeConverter.convertTo(XMLStreamWriter.class, (Object)buffer);
                FilteringXmlStreamWriter filteringWriter = new FilteringXmlStreamWriter(writer);
                marshaller.marshal(toMarshall, (XMLStreamWriter)filteringWriter);
            } else {
                marshaller.marshal(toMarshall, (Writer)buffer);
            }
            answer = this.parentTypeConverter.convertTo(type, exchange, (Object)((Object)buffer).toString());
        }
        return (T)answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshal(Unmarshaller unmarshaller, Exchange exchange, Object value) throws JAXBException, UnsupportedEncodingException, XMLStreamException {
        try {
            XMLStreamReader xmlReader;
            if (value instanceof XMLStreamReader) {
                xmlReader = (XMLStreamReader)value;
            } else if (value instanceof InputStream) {
                xmlReader = this.needFiltering(exchange) ? this.staxConverter.createXMLStreamReader((Reader)new NonXmlFilterReader(new InputStreamReader((InputStream)value, IOHelper.getCharsetName((Exchange)exchange)))) : this.staxConverter.createXMLStreamReader((InputStream)value, exchange);
            } else if (value instanceof Reader) {
                Reader reader = (Reader)value;
                if (this.needFiltering(exchange) && !(value instanceof NonXmlFilterReader)) {
                    reader = new NonXmlFilterReader((Reader)value);
                }
                xmlReader = this.staxConverter.createXMLStreamReader(reader);
            } else if (value instanceof Source) {
                xmlReader = this.staxConverter.createXMLStreamReader((Source)value);
            } else {
                throw new IllegalArgumentException("Cannot convert from " + value.getClass());
            }
            Object object = unmarshaller.unmarshal(xmlReader);
            return object;
        }
        finally {
            if (value instanceof Closeable) {
                IOHelper.close((Closeable)((Closeable)value), (String)"Unmarshalling", (Logger)LOG);
            }
        }
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange != null && (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)Boolean.FALSE, Boolean.class) != false;
    }

    protected synchronized <T> JAXBContext createContext(Class<T> type) throws JAXBException {
        AnnotatedElement ae = this.hasXmlRootElement(type) ? type : type.getPackage();
        JAXBContext context = this.contexts.get(ae);
        if (context == null) {
            if (this.hasXmlRootElement(type)) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                this.contexts.put(type, context);
            } else {
                context = JAXBContext.newInstance((String)type.getPackage().getName());
                this.contexts.put(type.getPackage(), context);
            }
        }
        return context;
    }

    protected <T> Unmarshaller getUnmarshaller(Class<T> type) throws JAXBException {
        JAXBContext context = this.createContext(type);
        return context.createUnmarshaller();
    }

    private static <T> boolean isNotStreamCacheType(Class<T> type) {
        return !StreamCache.class.isAssignableFrom(type);
    }
}

