/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PropertyBindingSupport;

@JdkService(value="rest-binding-jaxb-dataformat-factory")
public class JaxbRestBindingJaxbDataFormatFactory
implements RestBindingJaxbDataFormatFactory {
    public void setupJaxb(CamelContext camelContext, RestConfiguration config, String type, String outType, DataFormat jaxb, DataFormat outJaxb) throws Exception {
        JAXBContext jc;
        Class clazz = null;
        if (type != null) {
            String typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
            clazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (clazz != null) {
            JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.setJaxbContext(camelContext, jaxb, jc2);
        }
        this.setAdditionalConfiguration(camelContext, config, jaxb, "xml.in.");
        Class outClazz = null;
        if (outType != null) {
            String typeName = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
            outClazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (outClazz != null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
            this.setJaxbContext(camelContext, outJaxb, jc);
        } else if (clazz != null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.setJaxbContext(camelContext, outJaxb, jc);
        }
        this.setAdditionalConfiguration(camelContext, config, outJaxb, "xml.out.");
    }

    private void setJaxbContext(CamelContext camelContext, DataFormat jaxb, JAXBContext jc) throws Exception {
        ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(camelContext, (Object)jaxb, "context", (Object)jc);
    }

    private void setAdditionalConfiguration(CamelContext camelContext, RestConfiguration config, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.build().bind(camelContext, (Object)dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

