/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.job;

import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobList;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesJobProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesJobProducer.class);

    public KubernetesJobProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listJob": {
                this.doList(exchange, operation);
                break;
            }
            case "listJobByLabels": {
                this.doListJobByLabel(exchange, operation);
                break;
            }
            case "getJob": {
                this.doGetJob(exchange, operation);
                break;
            }
            case "createJob": {
                this.doCreateJob(exchange, operation);
                break;
            }
            case "deleteJob": {
                this.doDeleteJob(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        JobList jobList = (JobList)this.getEndpoint().getKubernetesClient().batch().jobs().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)jobList.getItems());
    }

    protected void doListJobByLabel(Exchange exchange, String operation) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesJobLabels", Map.class);
        if (ObjectHelper.isEmpty((Object)labels)) {
            LOG.error("Get Job by labels require specify a labels set");
            throw new IllegalArgumentException("Get Job by labels require specify a labels set");
        }
        MixedOperation jobs = this.getEndpoint().getKubernetesClient().batch().jobs();
        for (Map.Entry entry : labels.entrySet()) {
            jobs.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        JobList jobList = (JobList)jobs.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)jobList.getItems());
    }

    protected void doGetJob(Exchange exchange, String operation) throws Exception {
        Job job = null;
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)jobName)) {
            LOG.error("Get a specific job require specify a job name");
            throw new IllegalArgumentException("Get a specific job require specify a job name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific job require specify a namespace name");
            throw new IllegalArgumentException("Get a specific job require specify a namespace name");
        }
        job = (Job)((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().jobs().inNamespace(namespaceName)).withName(jobName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)job);
    }

    protected void doCreateJob(Exchange exchange, String operation) throws Exception {
        Job job = null;
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        JobSpec jobSpec = (JobSpec)exchange.getIn().getHeader("CamelKubernetesJobSpec", JobSpec.class);
        if (ObjectHelper.isEmpty((Object)jobName)) {
            LOG.error("Create a specific job require specify a job name");
            throw new IllegalArgumentException("Create a specific job require specify a job name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific job require specify a namespace name");
            throw new IllegalArgumentException("Create a specific job require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)jobSpec)) {
            LOG.error("Create a specific job require specify a hpa spec bean");
            throw new IllegalArgumentException("Create a specific job require specify a hpa spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesJobLabels", Map.class);
        Job jobCreating = ((JobBuilder)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(jobName)).withLabels(labels)).endMetadata()).withSpec(jobSpec)).build();
        job = (Job)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().jobs().inNamespace(namespaceName)).create((Object)jobCreating);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)job);
    }

    protected void doDeleteJob(Exchange exchange, String operation) throws Exception {
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)jobName)) {
            LOG.error("Delete a specific job require specify a job name");
            throw new IllegalArgumentException("Delete a specific job require specify a job name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific job require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific job require specify a namespace name");
        }
        ((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().jobs().inNamespace(namespaceName)).withName(jobName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
    }
}

