/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.secrets;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSecretsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSecretsProducer.class);

    public KubernetesSecretsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listSecrets": {
                this.doList(exchange, operation);
                break;
            }
            case "listSecretsByLabels": {
                this.doListSecretsByLabels(exchange, operation);
                break;
            }
            case "getSecret": {
                this.doGetSecret(exchange, operation);
                break;
            }
            case "createSecret": {
                this.doCreateSecret(exchange, operation);
                break;
            }
            case "deleteSecret": {
                this.doDeleteSecret(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        SecretList secretsList = (SecretList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().secrets().inAnyNamespace()).list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)secretsList.getItems());
    }

    protected void doListSecretsByLabels(Exchange exchange, String operation) throws Exception {
        SecretList secretsList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesSecretsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation secrets = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                secrets.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            secretsList = (SecretList)secrets.list();
        } else {
            FilterWatchListMultiDeletable secrets = (FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().secrets().inAnyNamespace();
            for (Map.Entry entry : labels.entrySet()) {
                secrets.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            secretsList = (SecretList)secrets.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)secretsList.getItems());
    }

    protected void doGetSecret(Exchange exchange, String operation) throws Exception {
        Secret secret = null;
        String secretName = (String)exchange.getIn().getHeader("CamelKubernetesSecretName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)secretName)) {
            LOG.error("Get a specific Secret require specify a Secret name");
            throw new IllegalArgumentException("Get a specific Secret require specify a Secret name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Secret require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Secret require specify a namespace name");
        }
        secret = (Secret)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).withName(secretName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)secret);
    }

    protected void doCreateSecret(Exchange exchange, String operation) throws Exception {
        Secret secret = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Secret secretToCreate = (Secret)exchange.getIn().getHeader("CamelKubernetesSecret", Secret.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific secret require specify a namespace name");
            throw new IllegalArgumentException("Create a specific secret require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)secretToCreate)) {
            LOG.error("Create a specific secret require specify a secret bean");
            throw new IllegalArgumentException("Create a specific secret require specify a secret bean");
        }
        secret = (Secret)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).create((Object)secretToCreate);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)secret);
    }

    protected void doDeleteSecret(Exchange exchange, String operation) throws Exception {
        String secretName = (String)exchange.getIn().getHeader("CamelKubernetesSecretName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)secretName)) {
            LOG.error("Delete a specific secret require specify a secret name");
            throw new IllegalArgumentException("Delete a specific secret require specify a secret name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific secret require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific secret require specify a namespace name");
        }
        boolean secretDeleted = (Boolean)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().secrets().inNamespace(namespaceName)).withName(secretName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)secretDeleted);
    }
}

