/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import com.sun.mail.imap.SortTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

public final class MailSorter {
    private MailSorter() {
    }

    public static void sortMessages(Message[] messages, SortTerm[] sortTerm) {
        List<SortTermWithDescending> sortTermsWithDescending = MailSorter.getSortTermsWithDescending(sortTerm);
        MailSorter.sortMessages(messages, sortTermsWithDescending);
    }

    private static List<SortTermWithDescending> getSortTermsWithDescending(SortTerm[] sortTerm) {
        ArrayList<SortTermWithDescending> sortTermsWithDescending = new ArrayList<SortTermWithDescending>(sortTerm.length);
        boolean descendingNext = false;
        for (SortTerm term : sortTerm) {
            if (term.equals(SortTerm.REVERSE)) {
                if (descendingNext) {
                    throw new IllegalArgumentException("Double reverse in sort term is not allowed");
                }
                descendingNext = true;
                continue;
            }
            sortTermsWithDescending.add(new SortTermWithDescending(term, descendingNext));
            descendingNext = false;
        }
        return sortTermsWithDescending;
    }

    private static void sortMessages(Message[] messages, final List<SortTermWithDescending> sortTermsWithDescending) {
        Arrays.sort(messages, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                try {
                    for (SortTermWithDescending reversableTerm : sortTermsWithDescending) {
                        int comparison = MailSorter.compareMessageProperty(m1, m2, reversableTerm.getTerm());
                        if (reversableTerm.isDescending()) {
                            comparison = -comparison;
                        }
                        if (comparison == 0) continue;
                        return comparison;
                    }
                    return 0;
                }
                catch (MessagingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    private static int compareMessageProperty(Message msg1, Message msg2, SortTerm property) throws MessagingException {
        if (property.equals(SortTerm.TO)) {
            InternetAddress addr1 = (InternetAddress)msg1.getRecipients(Message.RecipientType.TO)[0];
            InternetAddress addr2 = (InternetAddress)msg2.getRecipients(Message.RecipientType.TO)[0];
            return addr1.getAddress().compareTo(addr2.getAddress());
        }
        if (property.equals(SortTerm.CC)) {
            InternetAddress addr1 = (InternetAddress)msg1.getRecipients(Message.RecipientType.CC)[0];
            InternetAddress addr2 = (InternetAddress)msg2.getRecipients(Message.RecipientType.CC)[0];
            return addr1.getAddress().compareTo(addr2.getAddress());
        }
        if (property.equals(SortTerm.FROM)) {
            InternetAddress addr1 = (InternetAddress)msg1.getFrom()[0];
            InternetAddress addr2 = (InternetAddress)msg2.getFrom()[0];
            return addr1.getAddress().compareTo(addr2.getAddress());
        }
        if (property.equals(SortTerm.ARRIVAL)) {
            Date arr1 = msg1.getReceivedDate();
            Date arr2 = msg2.getReceivedDate();
            return arr1.compareTo(arr2);
        }
        if (property.equals(SortTerm.DATE)) {
            Date sent1 = msg1.getSentDate();
            Date sent2 = msg2.getSentDate();
            return sent1.compareTo(sent2);
        }
        if (property.equals(SortTerm.SIZE)) {
            int size1 = msg1.getSize();
            int size2 = msg2.getSize();
            return Integer.compare(size1, size2);
        }
        if (property.equals(SortTerm.SUBJECT)) {
            String sub1 = msg1.getSubject();
            String sub2 = msg2.getSubject();
            return sub1.compareTo(sub2);
        }
        throw new IllegalArgumentException(String.format("Unknown sort term: %s", property.toString()));
    }

    private static final class SortTermWithDescending {
        private SortTerm term;
        private boolean descending;

        private SortTermWithDescending(SortTerm term, boolean descending) {
            this.term = term;
            this.descending = descending;
        }

        public SortTerm getTerm() {
            return this.term;
        }

        public boolean isDescending() {
            return this.descending;
        }
    }
}

