/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupStep;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.EagerClassloadedHelper;
import org.apache.camel.main.HealthCheckConfigurationProperties;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainAutowiredLifecycleStrategy;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainSupportModelConfigurer;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    public static final String DEFAULT_PROPERTY_PLACEHOLDER_LOCATION = "classpath:application.properties;optional=true";
    public static final String INITIAL_PROPERTIES_LOCATION = "camel.main.initial-properties-location";
    public static final String OVERRIDE_PROPERTIES_LOCATION = "camel.main.override-properties-location";
    public static final String PROPERTY_PLACEHOLDER_LOCATION = "camel.main.property-placeholder-location";
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected volatile CamelContext camelContext;
    protected MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected Properties wildcardProperties = new OrderedProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;
    protected boolean standalone = true;
    private final MainHelper helper;

    protected BaseMainSupport() {
        this.helper = new MainHelper();
    }

    protected BaseMainSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.helper = new MainHelper();
    }

    private static CamelSagaService resolveLraSagaService(CamelContext camelContext) throws Exception {
        Set set = camelContext.getRegistry().findByType(CamelSagaService.class);
        if (set.size() == 1) {
            return (CamelSagaService)set.iterator().next();
        }
        CamelSagaService answer = (CamelSagaService)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder().newInstance("lra-saga-service", CamelSagaService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find LRASagaService on classpath. Add camel-lra to classpath."));
        camelContext.addService((Object)answer, true, false);
        return answer;
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    @Deprecated
    public boolean isAutoConfigurationEnabled() {
        return this.mainConfigurationProperties.isAutoConfigurationEnabled();
    }

    @Deprecated
    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.mainConfigurationProperties.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void setInitialProperties(Map<String, Object> initialProperties) {
        this.initialProperties = new OrderedProperties();
        this.initialProperties.putAll(initialProperties);
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void setOverrideProperties(Map<String, Object> initialProperties) {
        this.overrideProperties = new OrderedProperties();
        this.overrideProperties.putAll(initialProperties);
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.mainConfigurationProperties.getConfigurationClasses() != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.mainConfigurationProperties.getConfigurationClasses().split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.mainConfigurationProperties.addConfiguration(config);
            }
        }
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method != null) {
                LOG.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
                ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
                continue;
            }
            Object arg = camelContext;
            method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[]{CamelContext.class});
            if (method == null) {
                method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[]{Main.class});
                arg = this;
            }
            if (method == null) continue;
            LOG.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[]{arg});
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        Properties op;
        Properties ip;
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        if (pc.getLocations().isEmpty()) {
            String locations = this.propertyPlaceholderLocations;
            if (locations == null) {
                locations = MainHelper.lookupPropertyFromSysOrEnv(PROPERTY_PLACEHOLDER_LOCATION).orElse(this.defaultPropertyPlaceholderLocation);
            }
            if (locations != null) {
                locations = locations.trim();
            }
            if (!Objects.equals(locations, "false")) {
                pc.addLocation(locations);
                if (DEFAULT_PROPERTY_PLACEHOLDER_LOCATION.equals(locations)) {
                    LOG.debug("Using properties from: {}", (Object)locations);
                } else {
                    LOG.info("Using properties from: {}", (Object)locations);
                }
            }
        }
        if ((ip = this.initialProperties) == null || ip.isEmpty()) {
            Optional<String> location = MainHelper.lookupPropertyFromSysOrEnv(INITIAL_PROPERTIES_LOCATION);
            if (location.isPresent()) {
                try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location.get());){
                    ip = new Properties();
                    ip.load(is);
                }
            }
        }
        if (ip != null) {
            pc.setInitialProperties(ip);
        }
        if ((op = this.overrideProperties) == null || op.isEmpty()) {
            Optional<String> location = MainHelper.lookupPropertyFromSysOrEnv(OVERRIDE_PROPERTIES_LOCATION);
            if (location.isPresent()) {
                try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location.get());){
                    op = new Properties();
                    op.load(is);
                }
            }
        }
        if (op != null) {
            pc.setOverrideProperties(op);
        }
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
            this.autowireWildcardProperties(camelContext);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            LOG.info("Auto-configuration summary");
            autoConfiguredProperties.forEach((k, v) -> {
                if (SensitiveUtils.containsSensitive((String)k)) {
                    LOG.info("    {}=xxxxxx", k);
                } else {
                    LOG.info("    {}={}", k, v);
                }
            });
        }
        this.helper.bootstrapDone();
    }

    protected void configureStartupRecorder(CamelContext camelContext) {
        StartupStepRecorder fr;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        Object value = prop.remove("camel.main.startupRecorder");
        if (value == null) {
            value = prop.remove("camel.main.startup-recorder");
        }
        if (value != null) {
            this.mainConfigurationProperties.setStartupRecorder(value.toString());
        }
        if ((value = prop.remove("camel.main.startupRecorderRecording")) == null) {
            value = prop.remove("camel.main.startup-recorder-recording");
        }
        if (value != null) {
            this.mainConfigurationProperties.setStartupRecorderRecording("true".equalsIgnoreCase(value.toString()));
        }
        if ((value = prop.remove("camel.main.startupRecorderProfile")) == null) {
            value = prop.remove("camel.main.startup-recorder-profile");
        }
        if (value != null) {
            this.mainConfigurationProperties.setStartupRecorderProfile(CamelContextHelper.parseText((CamelContext)camelContext, (String)value.toString()));
        }
        if ((value = prop.remove("camel.main.startupRecorderDuration")) == null) {
            value = prop.remove("camel.main.startup-recorder-duration");
        }
        if (value != null) {
            this.mainConfigurationProperties.setStartupRecorderDuration(Long.parseLong(value.toString()));
        }
        if ((value = prop.remove("camel.main.startupRecorderMaxDepth")) == null) {
            value = prop.remove("camel.main.startup-recorder-max-depth");
        }
        if (value != null) {
            this.mainConfigurationProperties.setStartupRecorderMaxDepth(Integer.parseInt(value.toString()));
        }
        if ("off".equals(this.mainConfigurationProperties.getStartupRecorder()) || "false".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
        } else if (("jfr".equals(this.mainConfigurationProperties.getStartupRecorder()) || "java-flight-recorder".equals(this.mainConfigurationProperties.getStartupRecorder()) || this.mainConfigurationProperties.getStartupRecorder() == null) && (fr = (StartupStepRecorder)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(this.mainConfigurationProperties.isStartupRecorderRecording());
            fr.setStartupRecorderDuration(this.mainConfigurationProperties.getStartupRecorderDuration());
            fr.setRecordingProfile(this.mainConfigurationProperties.getStartupRecorderProfile());
            fr.setMaxDepth(this.mainConfigurationProperties.getStartupRecorderMaxDepth());
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setStartupStepRecorder(fr);
        }
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = new RoutesConfigurer();
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
        }
        configurer.setBeanPostProcessor(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor());
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesBuilderClasses(this.mainConfigurationProperties.getRoutesBuilderClasses());
        configurer.setPackageScanRouteBuilders(this.mainConfigurationProperties.getPackageScanRouteBuilders());
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        configurer.configureRoutes(camelContext);
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        StartupStep step;
        camelContext.getLifecycleStrategies().removeIf(s -> s instanceof AutowiredLifecycleStrategy);
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainAutowiredLifecycleStrategy(camelContext));
        this.configurePropertiesService(camelContext);
        this.configureStartupRecorder(camelContext);
        camelContext.build();
        for (MainListener listener : this.listeners) {
            listener.beforeInitialize(this);
        }
        for (MainListener listener : this.listeners) {
            listener.beforeConfigure(this);
        }
        StartupStepRecorder recorder = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "autoconfigure", "Auto Configure");
            this.autoconfigure(camelContext);
            recorder.endStep(step);
        }
        if (this.mainConfigurationProperties.isEagerClassloading()) {
            step = recorder.beginStep(BaseMainSupport.class, "classloading", "Eager Classloading");
            EagerClassloadedHelper.eagerLoadClasses();
            recorder.endStep(step);
        }
        this.configureLifecycle(camelContext);
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "configureRoutes", "Collect Routes");
            this.configureRoutes(camelContext);
            recorder.endStep(step);
        }
        for (MainListener listener : this.listeners) {
            listener.afterConfigure(this);
            listener.configure(camelContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationFailFast(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        void var8_13;
        Object val;
        Object object;
        Object jvmEnabled;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove("camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (envEnabled == null && (envEnabled = prop.remove("camel.main.auto-configuration-environment-variables-enabled")) != null) {
            this.mainConfigurationProperties.setAutoConfigurationEnvironmentVariablesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)envEnabled.toString()));
            autoConfiguredProperties.put("camel.main.auto-configuration-environment-variables-enabled", envEnabled.toString());
        }
        if ((jvmEnabled = prop.remove("camel.main.autoConfigurationSystemPropertiesEnabled")) == null && (jvmEnabled = prop.remove("camel.main.auto-configuration-system-properties-enabled")) != null) {
            this.mainConfigurationProperties.setAutoConfigurationSystemPropertiesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)jvmEnabled.toString()));
            autoConfiguredProperties.put("camel.main.auto-configuration-system-properties-enabled", jvmEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
                LOG.debug("Properties from OS environment variables:");
                for (String string : propENV.stringPropertyNames()) {
                    LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
                }
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."});
            if (!propJVM.isEmpty()) {
                prop.putAll((Map<?, ?>)propJVM);
                LOG.debug("Properties from JVM system properties:");
                for (String key : propJVM.stringPropertyNames()) {
                    LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
                }
            }
        }
        Object object2 = object = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (propJVM != null && (val = propJVM.remove("camel.main.autoconfigurationfailfast")) != null) {
            Object object3 = val;
        }
        if (var8_13 != null) {
            this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)var8_13.toString()));
        } else {
            void var8_16;
            Object object4 = prop.remove("camel.main.autoConfigurationFailFast");
            if (object4 == null) {
                Object object5 = prop.remove("camel.main.auto-configuration-fail-fast");
            }
            if (var8_16 != null) {
                this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)var8_16.toString()));
                autoConfiguredProperties.put("camel.main.auto-configuration-fail-fast", var8_16.toString());
            }
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        boolean hc;
        if (config.getFileConfigurations() != null) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doConfigureCamelContextFromMainConfiguration$5(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        DefaultConfigurationConfigurer.afterConfigure(camelContext);
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."});
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
                LOG.debug("Properties from OS environment variables:");
                for (String key : propENV.stringPropertyNames()) {
                    LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
                }
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."});
            if (!propJVM.isEmpty()) {
                prop.putAll((Map<?, ?>)propJVM);
                LOG.debug("Properties from JVM system properties:");
                for (String key : propJVM.stringPropertyNames()) {
                    LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
                }
            }
        }
        LinkedHashMap<String, Object> contextProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> hystrixProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resilience4jProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> faultToleranceProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> restProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> threadPoolProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> healthProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> lraProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> routeTemplateProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> beansProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> devConsoleProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> globalOptions = new LinkedHashMap<String, String>();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            if (key.startsWith("camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                contextProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.hystrix.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                hystrixProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.faulttolerance.")) {
                value = prop.getProperty(key);
                option = key.substring(21);
                MainHelper.validateOptionAndValue(key, option, value);
                faultToleranceProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                MainHelper.validateOptionAndValue(key, option, value);
                restProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.threadpool.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                threadPoolProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.health.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                healthProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.lra.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                lraProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.route-template")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                MainHelper.validateOptionAndValue(key, option, value);
                routeTemplateProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.dev-console.")) {
                value = prop.getProperty(key);
                option = key.substring(18);
                MainHelper.validateOptionAndValue(key, option, value);
                devConsoleProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.beans.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                beansProperties.put(MainHelper.optionKey(option), value);
                continue;
            }
            if (!key.startsWith("camel.global-options.")) continue;
            value = prop.getProperty(key);
            option = key.substring(21);
            MainHelper.validateOptionAndValue(key, option, value);
            globalOptions.put(MainHelper.optionKey(option), value);
        }
        if (!globalOptions.isEmpty()) {
            this.mainConfigurationProperties.setGlobalOptions(globalOptions);
        }
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), this.mainConfigurationProperties.isAutoConfigurationLogSummary(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty() || this.mainConfigurationProperties.hasRestConfiguration()) {
            RestConfigurationProperties rest = this.mainConfigurationProperties.rest();
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, (Object)rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            camelContext.setRestConfiguration((RestConfiguration)rest);
        }
        if (!threadPoolProperties.isEmpty() || this.mainConfigurationProperties.hasThreadPoolConfiguration()) {
            LOG.debug("Auto-configuring Thread Pool from loaded properties: {}", (Object)threadPoolProperties.size());
            MainSupportModelConfigurer.setThreadPoolProperties(camelContext, this.mainConfigurationProperties, threadPoolProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        boolean bl = hc = this.mainConfigurationProperties.health().getEnabled() != null;
        if (hc || !healthProperties.isEmpty() || this.mainConfigurationProperties.hasHealthCheckConfiguration()) {
            LOG.debug("Auto-configuring HealthCheck from loaded properties: {}", (Object)healthProperties.size());
            this.setHealthCheckProperties(camelContext, healthProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!routeTemplateProperties.isEmpty()) {
            LOG.debug("Auto-configuring Route templates from loaded properties: {}", (Object)routeTemplateProperties.size());
            this.setRouteTemplateProperties(camelContext, routeTemplateProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!lraProperties.isEmpty() || this.mainConfigurationProperties.hasLraConfiguration()) {
            LOG.debug("Auto-configuring Saga LRA from loaded properties: {}", (Object)lraProperties.size());
            this.setLraCheckProperties(camelContext, lraProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!devConsoleProperties.isEmpty()) {
            LOG.debug("Auto-configuring Dev Console from loaded properties: {}", (Object)devConsoleProperties.size());
            this.setDevConsoleProperties(camelContext, devConsoleProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        MainSupportModelConfigurer.configureModelCamelContext(camelContext, this.mainConfigurationProperties, autoConfiguredProperties, hystrixProperties, resilience4jProperties, faultToleranceProperties);
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={}", k, v));
        }
        if (!hystrixProperties.isEmpty()) {
            hystrixProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.hystrix.{}={}", k, v));
        }
        if (!resilience4jProperties.isEmpty()) {
            resilience4jProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={}", k, v));
        }
        if (!faultToleranceProperties.isEmpty()) {
            faultToleranceProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.faulttolerance.{}={}", k, v));
        }
        if (!restProperties.isEmpty()) {
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={}", k, v));
        }
        if (!threadPoolProperties.isEmpty()) {
            threadPoolProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.threadpool.{}={}", k, v));
        }
        if (!healthProperties.isEmpty()) {
            healthProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.health.{}={}", k, v));
        }
        if (!routeTemplateProperties.isEmpty()) {
            routeTemplateProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.routetemplate.{}={}", k, v));
        }
        if (!lraProperties.isEmpty()) {
            lraProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.lra.{}={}", k, v));
        }
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
    }

    private void setRouteTemplateProperties(CamelContext camelContext, Map<String, Object> routeTemplateProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        for (Map.Entry<String, Object> entry : routeTemplateProperties.entrySet()) {
            String id = StringHelper.between((String)entry.getKey(), (String)"[", (String)"]");
            String key = StringHelper.after((String)entry.getKey(), (String)"].");
            source.addParameter(id, key, entry.getValue());
        }
        camelContext.getRegistry().bind("CamelMainRouteTemplateParametersSource", RouteTemplateParameterSource.class, (Object)source);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(routeTemplateProperties);
        sorted.forEach((k, v) -> autoConfiguredProperties.put("camel.route-template" + k, v.toString()));
        routeTemplateProperties.clear();
    }

    private void setHealthCheckProperties(CamelContext camelContext, Map<String, Object> healthCheckProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        HealthCheck hc;
        HealthCheckRegistry hcr = (HealthCheckRegistry)camelContext.getExtension(HealthCheckRegistry.class);
        if (hcr == null) {
            LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
            return;
        }
        HealthConfigurationProperties health = this.mainConfigurationProperties.health();
        Map hcConfig = PropertiesHelper.extractProperties(healthCheckProperties, (String)"config", (boolean)false);
        HashMap<String, HealthCheckConfigurationProperties> hcConfigs = new HashMap<String, HealthCheckConfigurationProperties>();
        for (Map.Entry entry : hcConfig.entrySet()) {
            HealthCheckConfigurationProperties hcp;
            String parent = StringHelper.between((String)((String)entry.getKey()), (String)"[", (String)"]");
            if (parent == null || (hcp = (HealthCheckConfigurationProperties)((Object)hcConfigs.get(parent))) != null) continue;
            hcp = new HealthCheckConfigurationProperties();
            hcConfigs.put(parent, hcp);
        }
        if (health.getConfig() != null) {
            health.getConfig().putAll(hcConfigs);
        } else {
            health.setConfig(hcConfigs);
        }
        MainHelper.setPropertiesOnTarget(camelContext, health, healthCheckProperties, "camel.health.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (health.getEnabled() != null) {
            hcr.setEnabled(health.getEnabled().booleanValue());
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("context") || health.getContextEnabled() != null) && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
            if (health.getContextEnabled() != null) {
                hc.getConfiguration().setEnabled(health.getContextEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("routes") || health.getRoutesEnabled() != null) && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
            if (health.getRoutesEnabled() != null) {
                hc.setEnabled(health.getRoutesEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("consumers") || health.getRegistryEnabled() != null) && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
            if (health.getConsumersEnabled() != null) {
                hc.setEnabled(health.getConsumersEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("registry") || health.getRegistryEnabled() != null) && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
            if (health.getRegistryEnabled() != null) {
                hc.setEnabled(health.getRegistryEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        for (String id : health.getConfig().keySet()) {
            HealthCheckConfiguration hcc = health.getConfig().get(id);
            String parent = hcc.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("HealthCheck with id: " + id + " must have parent configured");
            }
            Object hc2 = hcr.getCheck(parent).orElse(null);
            if (hc2 != null) continue;
            hc2 = hcr.resolveById(parent);
            if (hc2 == null) {
                LOG.warn("Cannot resolve HealthCheck with id: {} from classpath.", (Object)parent);
                continue;
            }
            hcr.register(hc2);
            if (hc2 instanceof HealthCheck) {
                ((HealthCheck)hc2).getConfiguration().setParent(hcc.getParent());
                ((HealthCheck)hc2).getConfiguration().setEnabled(hcc.isEnabled());
                ((HealthCheck)hc2).getConfiguration().setFailureThreshold(hcc.getFailureThreshold());
                ((HealthCheck)hc2).getConfiguration().setSuccessThreshold(hcc.getSuccessThreshold());
                ((HealthCheck)hc2).getConfiguration().setInterval(hcc.getInterval());
                continue;
            }
            if (!(hc2 instanceof HealthCheckRepository)) continue;
            ((HealthCheckRepository)hc2).addConfiguration(id, hcc);
        }
    }

    private void setLraCheckProperties(CamelContext camelContext, Map<String, Object> lraProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        boolean enabled;
        Object obj = lraProperties.remove("enabled");
        if (obj != null) {
            autoConfiguredProperties.put("camel.lra.enabled", obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelSagaService css = BaseMainSupport.resolveLraSagaService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, css, lraProperties, "camel.lra.", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setDevConsoleProperties(CamelContext camelContext, Map<String, Object> properties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(properties.keySet());
        for (String key : keys) {
            String name = StringHelper.before((String)key, (String)".");
            DevConsole console = ((DevConsoleRegistry)camelContext.getExtension(DevConsoleRegistry.class)).resolveById(name);
            if (console == null) {
                throw new IllegalArgumentException("Cannot resolve DevConsole with id: " + name);
            }
            Map config = PropertiesHelper.extractProperties(properties, (String)(name + "."));
            MainHelper.setPropertiesOnTarget(camelContext, console, config, "camel.dev-console." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void bindBeansToRegistry(CamelContext camelContext, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean logSummary, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(properties.keySet());
        Set beans = properties.keySet().stream().map(k -> StringHelper.before((String)k, (String)".", (String)k)).collect(Collectors.toSet());
        for (String key : keys) {
            if (key.indexOf(46) != -1) continue;
            String name = key;
            Object value = properties.remove(key);
            Object bean = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)value);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + name + " from value: " + value);
            }
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)org.apache.camel.util.ObjectHelper.classCanonicalName((Object)bean));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)org.apache.camel.util.ObjectHelper.classCanonicalName((Object)bean));
            }
            camelContext.getRegistry().bind(name, bean);
        }
        for (String name : beans) {
            Object bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            Map config = PropertiesHelper.extractProperties(properties, (String)(name + "."));
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."});
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."});
            if (!propJVM.isEmpty()) {
                prop.putAll((Map<?, ?>)propJVM);
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(46, 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            MainHelper.validateOptionAndValue(key, option, value);
            properties.put(MainHelper.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            propENV.remove(INITIAL_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(OVERRIDE_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(PROPERTY_PLACEHOLDER_LOCATION.replace('-', '.'));
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."});
            propJVM.remove(INITIAL_PROPERTIES_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)INITIAL_PROPERTIES_LOCATION));
            propJVM.remove(OVERRIDE_PROPERTIES_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)OVERRIDE_PROPERTIES_LOCATION));
            propJVM.remove(PROPERTY_PLACEHOLDER_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)PROPERTY_PLACEHOLDER_LOCATION));
            if (!propJVM.isEmpty()) {
                prop.putAll((Map<?, ?>)propJVM);
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            MainHelper.validateOptionAndValue(key, option, value);
            properties.put(MainHelper.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propJVM;
        OrderedProperties prop = new OrderedProperties();
        Properties propPC = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll((Map<?, ?>)propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Map<String, String> env = MainHelper.filterEnvVariables(new String[]{"camel.component.", "camel.dataformat.", "camel.language."});
            LOG.debug("Gathered {} ENV variables to configure components, dataformats, languages", (Object)env.size());
            OrderedProperties propENV = new OrderedProperties();
            this.helper.addComponentEnvVariables(env, (Properties)propENV, false);
            this.helper.addDataFormatEnvVariables(env, (Properties)propENV, false);
            this.helper.addLanguageEnvVariables(env, (Properties)propENV, false);
            if (!env.isEmpty()) {
                LOG.debug("Remaining {} ENV variables to configure custom components, dataformats, languages", (Object)env.size());
                this.helper.addComponentEnvVariables(env, (Properties)propENV, true);
                this.helper.addDataFormatEnvVariables(env, (Properties)propENV, true);
                this.helper.addLanguageEnvVariables(env, (Properties)propENV, true);
            }
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propJVM);
        }
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            this.wildcardProperties.put(key, prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove(key);
        }
        for (String key : prop.stringPropertyNames()) {
            MainHelper.computeProperties("camel.component.", key, (Properties)prop, properties, name -> {
                Component target = camelContext.getComponent(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.dataformat.", key, (Properties)prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.language.", key, (Properties)prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage(name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (Map.Entry entry : properties.entrySet()) {
            MainHelper.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                PropertyOptionKey pok = (PropertyOptionKey)entry.getKey();
                Map values = (Map)entry.getValue();
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + k, stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        String match = ("camel.component." + name).toLowerCase(Locale.ENGLISH);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.ENGLISH);
            if (!match.startsWith(mKey)) continue;
            MainHelper.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                MainHelper.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                LOG.info("Auto-configuration component {} summary", (Object)name);
                autoConfiguredProperties.forEach((k, v) -> {
                    if (SensitiveUtils.containsSensitive((String)k)) {
                        LOG.info("    {}=xxxxxx", k);
                    } else {
                        LOG.info("    {}={}", k, v);
                    }
                });
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$5(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }
}

