/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PackageDataFormatMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File dataFormatOutDir;
    protected File schemaOutDir;
    private MavenProjectHelper projectHelper;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageDataFormatMojo.prepareDataFormat(this.getLog(), this.project, this.projectHelper, this.dataFormatOutDir, this.schemaOutDir, this.buildContext);
    }

    public static void prepareDataFormat(Log log, MavenProject project, MavenProjectHelper projectHelper, File dataFormatOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        int count;
        StringBuilder buffer;
        File camelMetaDir;
        block30: {
            camelMetaDir = new File(dataFormatOutDir, "META-INF/services/org/apache/camel/");
            if (projectHelper != null) {
                projectHelper.addResource(project, dataFormatOutDir.getPath(), Collections.singletonList("**/dataformat.properties"), Collections.emptyList());
            }
            if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/dataformat")) {
                return;
            }
            HashMap<String, String> javaTypes = new HashMap<String, String>();
            buffer = new StringBuilder();
            count = 0;
            for (Resource r : project.getBuild().getResources()) {
                File[] files;
                File f = new File(r.getDirectory());
                if (!f.exists()) {
                    f = new File(project.getBasedir(), r.getDirectory());
                }
                if (!(f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
                for (File file : files) {
                    String javaType = PackageDataFormatMojo.readClassFromCamelResource(file, buffer, buildContext);
                    if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                        ++count;
                    }
                    if (javaType == null) continue;
                    javaTypes.put(file.getName(), javaType);
                }
            }
            boolean apacheCamel = "org.apache.camel".equals(project.getGroupId());
            try {
                File core;
                Artifact camelCore;
                if (!apacheCamel || count <= 0 || (camelCore = PackageDataFormatMojo.findCamelCoreArtifact(project)) == null || (core = camelCore.getFile()) == null) break block30;
                URL url = new URL("file", null, core.getAbsolutePath());
                try (URLClassLoader loader = new URLClassLoader(new URL[]{url});){
                    for (Map.Entry entry : javaTypes.entrySet()) {
                        String name = (String)entry.getKey();
                        String javaType = (String)entry.getValue();
                        String modelName = PackageDataFormatMojo.asModelName(name);
                        InputStream is = loader.getResourceAsStream("org/apache/camel/model/dataformat/" + modelName + ".json");
                        if (is == null) {
                            is = new FileInputStream(new File(core, "org/apache/camel/model/dataformat/" + modelName + ".json"));
                        }
                        String json = PackageHelper.loadText(is);
                        DataFormatModel dataFormatModel = PackageDataFormatMojo.extractDataFormatModel(project, json, modelName, name, javaType);
                        log.debug((CharSequence)("Model " + dataFormatModel));
                        String properties = PackageHelper.after(json, "  \"properties\": {");
                        properties = PackageDataFormatMojo.prepareBindyProperties(name, properties);
                        properties = PackageDataFormatMojo.prepareJsonProperties(name, properties);
                        String schema = PackageDataFormatMojo.createParameterJsonSchema(dataFormatModel, properties);
                        log.debug((CharSequence)("JSon schema\n" + schema));
                        File dir = new File(schemaOutDir, PackageDataFormatMojo.schemaSubDirectory(dataFormatModel.getJavaType()));
                        dir.mkdirs();
                        File out = new File(dir, name + ".json");
                        OutputStream fos = buildContext.newFileOutputStream(out);
                        fos.write(schema.getBytes());
                        fos.close();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " data format"));
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading dataformat model from camel-core. Reason: " + e, e);
            }
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("dataFormats", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "dataformat.properties");
            if (outFile.exists()) {
                try {
                    Properties existing = new Properties();
                    FileInputStream is = new FileInputStream(outFile);
                    existing.load(is);
                    ((InputStream)is).close();
                    if (existing.equals(properties)) {
                        log.debug((CharSequence)"No dataformat changes detected");
                        return;
                    }
                }
                catch (IOException existing) {
                    // empty catch block
                }
            }
            try {
                OutputStream os = buildContext.newFileOutputStream(outFile);
                properties.store(os, "Generated by camel-package-maven-plugin");
                os.close();
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "dataformats: " : "dataformat: ") + names));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        }
        log.debug((CharSequence)"No META-INF/services/org/apache/camel/dataformat directory found. Are you sure you have created a Camel data format?");
    }

    private static DataFormatModel extractDataFormatModel(MavenProject project, String json, String modelName, String name, String javaType) throws Exception {
        DataFormatModel dataFormatModel = new DataFormatModel();
        dataFormatModel.setName(name);
        dataFormatModel.setTitle("");
        dataFormatModel.setModelName(modelName);
        dataFormatModel.setLabel("");
        dataFormatModel.setDescription(project.getDescription());
        dataFormatModel.setJavaType(javaType);
        dataFormatModel.setGroupId(project.getGroupId());
        dataFormatModel.setArtifactId(project.getArtifactId());
        dataFormatModel.setVersion(project.getVersion());
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        for (Map<String, String> row : rows) {
            if (row.containsKey("title")) {
                String title = row.get("title");
                dataFormatModel.setTitle(PackageDataFormatMojo.asModelTitle(name, title));
            }
            if (row.containsKey("label")) {
                dataFormatModel.setLabel(row.get("label"));
            }
            if (row.containsKey("deprecated")) {
                dataFormatModel.setDeprecated(row.get("deprecated"));
            }
            if (row.containsKey("deprecationNote")) {
                dataFormatModel.setDeprecationNote(row.get("deprecationNote"));
            }
            if (row.containsKey("javaType")) {
                dataFormatModel.setModelJavaType(row.get("javaType"));
            }
            if (row.containsKey("firstVersion")) {
                dataFormatModel.setFirstVersion(row.get("firstVersion"));
            }
            if (!row.containsKey("description")) continue;
            dataFormatModel.setDescription(row.get("description"));
        }
        String firstVersion = PackageDataFormatMojo.prepareJsonFirstVersion(name);
        if (firstVersion != null) {
            dataFormatModel.setFirstVersion(firstVersion);
        }
        return dataFormatModel;
    }

    private static String prepareBindyProperties(String name, String properties) {
        String bindy = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\"";
        String bindyCsv = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Csv\"";
        String bindyFixed = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Fixed\"";
        String bindyKvp = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"KeyValue\"";
        if ("bindy-csv".equals(name)) {
            properties = properties.replace(bindy, bindyCsv);
        } else if ("bindy-fixed".equals(name)) {
            properties = properties.replace(bindy, bindyFixed);
        } else if ("bindy-kvp".equals(name)) {
            properties = properties.replace(bindy, bindyKvp);
        }
        return properties;
    }

    private static String prepareJsonProperties(String name, String properties) {
        String json = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"XStream\"";
        String jsonGson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Gson\"";
        String jsonJackson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Jackson\"";
        String jsonJohnzon = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Johnzon\"";
        String jsonXStream = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"XStream\"";
        String jsonFastjson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Fastjson\"";
        if ("json-gson".equals(name)) {
            properties = properties.replace(json, jsonGson);
        } else if ("json-jackson".equals(name)) {
            properties = properties.replace(json, jsonJackson);
        } else if ("json-johnzon".equals(name)) {
            properties = properties.replace(json, jsonJohnzon);
        } else if ("json-xstream".equals(name)) {
            properties = properties.replace(json, jsonXStream);
        } else if ("json-fastjson".equals(name)) {
            properties = properties.replace(json, jsonFastjson);
        }
        return properties;
    }

    private static String prepareJsonFirstVersion(String name) {
        if ("json-gson".equals(name)) {
            return "2.10.0";
        }
        if ("json-jackson".equals(name)) {
            return "2.0.0";
        }
        if ("json-johnzon".equals(name)) {
            return "2.18.0";
        }
        if ("json-xstream".equals(name)) {
            return "2.0.0";
        }
        if ("json-fastjson".equals(name)) {
            return "2.20.0";
        }
        return null;
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            Map<String, String> map = PackageHelper.parseAsMap(text);
            return map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("json-gson".equals(name) || "json-jackson".equals(name) || "json-johnzon".equals(name) || "json-xstream".equals(name) || "json-fastjson".equals(name)) {
            return "json";
        }
        if ("bindy-csv".equals(name) || "bindy-fixed".equals(name) || "bindy-kvp".equals(name)) {
            return "bindy";
        }
        if ("zipfile".equals(name)) {
            return "zipFile";
        }
        if ("yaml-snakeyaml".equals(name)) {
            return "yaml";
        }
        return name;
    }

    private static String asModelTitle(String name, String title) {
        if ("json-gson".equals(name)) {
            return "JSon GSon";
        }
        if ("json-jackson".equals(name)) {
            return "JSon Jackson";
        }
        if ("json-johnzon".equals(name)) {
            return "JSon Johnzon";
        }
        if ("json-xstream".equals(name)) {
            return "JSon XStream";
        }
        if ("json-fastjson".equals(name)) {
            return "JSon Fastjson";
        }
        if ("bindy-csv".equals(name)) {
            return "Bindy CSV";
        }
        if ("bindy-fixed".equals(name)) {
            return "Bindy Fixed Length";
        }
        if ("bindy-kvp".equals(name)) {
            return "Bindy Key Value Pair";
        }
        if ("yaml-snakeyaml".equals(name)) {
            return "YAML SnakeYAML";
        }
        return title;
    }

    private static Artifact findCamelCoreArtifact(MavenProject project) {
        Artifact artifact2 = project.getArtifact();
        if (artifact2.getGroupId().equals("org.apache.camel") && artifact2.getArtifactId().equals("camel-core")) {
            return artifact2;
        }
        for (Artifact artifact2 : project.getDependencyArtifacts()) {
            if (!artifact2.getGroupId().equals("org.apache.camel") || !artifact2.getArtifactId().equals("camel-core")) continue;
            return artifact2;
        }
        return null;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(DataFormatModel dataFormatModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"dataformat\": {");
        buffer.append("\n    \"name\": \"").append(dataFormatModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("dataformat").append("\",");
        buffer.append("\n    \"modelName\": \"").append(dataFormatModel.getModelName()).append("\",");
        if (dataFormatModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(dataFormatModel.getTitle()).append("\",");
        }
        if (dataFormatModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(dataFormatModel.getDescription()).append("\",");
        }
        boolean deprecated = "true".equals(dataFormatModel.getDeprecated());
        buffer.append("\n    \"deprecated\": ").append(deprecated).append(",");
        if (dataFormatModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(dataFormatModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(dataFormatModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(dataFormatModel.getJavaType()).append("\",");
        if (dataFormatModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(dataFormatModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(dataFormatModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(dataFormatModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(dataFormatModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class DataFormatModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String firstVersion;
        private String label;
        private String deprecated;
        private String deprecationNote;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private DataFormatModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public void setDeprecationNote(String deprecationNote) {
            this.deprecationNote = deprecationNote;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "DataFormatModel[name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", modelName='" + this.modelName + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", deprecated='" + this.deprecated + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

