/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.maven.packaging.model.ExampleModel;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;

public class PrepareExampleMojo
extends AbstractMojo {
    protected MavenProject project;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeExamplesReadme();
    }

    protected void executeExamplesReadme() throws MojoExecutionException, MojoFailureException {
        TreeSet<File> examples = new TreeSet<File>();
        String currentDir = Paths.get(".", new String[0]).normalize().toAbsolutePath().toString();
        if (!currentDir.endsWith("examples")) {
            return;
        }
        File dir = new File(".");
        File[] files = dir.listFiles();
        if (files != null) {
            examples.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ExampleModel> models = new ArrayList<ExampleModel>();
            for (File file : examples) {
                File pom;
                if (!file.isDirectory() || !file.getName().startsWith("camel-example") || !(pom = new File(file, "pom.xml")).exists()) continue;
                String existing = FileUtils.readFileToString((File)pom, (Charset)Charset.defaultCharset());
                ExampleModel model = new ExampleModel();
                model.setFileName(file.getName());
                String name = StringHelper.between(existing, "<name>", "</name>");
                String title = StringHelper.between(existing, "<title>", "</title>");
                String description = StringHelper.between(existing, "<description>", "</description>");
                String category = StringHelper.between(existing, "<category>", "</category>");
                if (title != null) {
                    model.setTitle(title);
                } else {
                    model.setTitle(PrepareExampleMojo.asTitle(file.getName()));
                }
                if (description != null) {
                    model.setDescription(description);
                }
                if (category != null) {
                    model.setCategory(category);
                }
                if (name != null && name.contains("(deprecated)")) {
                    model.setDeprecated("true");
                } else {
                    model.setDeprecated("false");
                }
                String[] readmes = new File(file, ".").list((folder, fileName) -> fileName.toLowerCase().startsWith("readme"));
                if (readmes != null && readmes.length == 1) {
                    model.setReadmeFileName(readmes[0]);
                }
                models.add(model);
            }
            Collections.sort(models, (Comparator)new ExampleComparator());
            long deprecated = models.stream().filter(m -> "true".equals(m.getDeprecated())).count();
            File file = new File(".", "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateExamples(models, deprecated);
            boolean updated = this.updateExamples(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private String templateExamples(List<ExampleModel> models, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-examples.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("examples", models);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean updateExamples(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// examples: START", "// examples: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// examples: START");
                String after = StringHelper.after(text, "// examples: END");
                text = before + "// examples: START\n" + changed + "\n// examples: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// examples: START");
            this.getLog().warn((CharSequence)"\t// examples: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private static String asTitle(String fileName) {
        String answer = fileName.toLowerCase();
        if (answer.startsWith("camel-example-")) {
            answer = answer.substring(14);
        }
        answer = StringHelper.camelDashToTitle(answer);
        return answer;
    }

    private static class ExampleComparator
    implements Comparator<ExampleModel> {
        private ExampleComparator() {
        }

        @Override
        public int compare(ExampleModel o1, ExampleModel o2) {
            int num = o1.getCategory().compareToIgnoreCase(o2.getCategory());
            if (num == 0) {
                return o1.getFileName().compareToIgnoreCase(o2.getFileName());
            }
            return num;
        }
    }
}

