/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.SpringBootAutoConfigureOptionModel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.json.simple.DeserializationException;
import org.json.simple.JsonArray;
import org.json.simple.JsonObject;
import org.json.simple.Jsoner;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

public class UpdateSpringBootAutoConfigurationReadmeMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File buildDir;
    protected File componentsDir;
    protected Boolean failFast;
    protected Boolean failOnMissingDescription;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeStarter(this.project.getBasedir());
        }
        catch (Exception e) {
            throw new MojoFailureException("Error processing spring-configuration-metadata.json", (Throwable)e);
        }
    }

    private void executeStarter(File starter) throws Exception {
        File jsonFile = new File(this.buildDir, "classes/META-INF/spring-configuration-metadata.json");
        if (jsonFile.exists()) {
            this.getLog().debug((CharSequence)("Processing Spring Boot auto-configuration file: " + jsonFile));
            Object js = Jsoner.deserialize((Reader)new FileReader(jsonFile));
            if (js != null) {
                File[] docFiles;
                File docFolder;
                String componentName;
                String name = starter.getName();
                if (!UpdateSpringBootAutoConfigurationReadmeMojo.isValidStarter(name)) {
                    return;
                }
                File compDir = this.getComponentsDir(name);
                if ("camel-spring-boot".equals(name)) {
                    componentName = "spring-boot";
                    docFolder = new File(compDir, "/src/main/docs/");
                    docFiles = docFolder.listFiles(new ComponentDocFilter(componentName));
                } else if ("camel-univocity-parsers-starter".equals(name)) {
                    componentName = "univocity";
                    docFolder = new File(compDir, "camel-univocity-parsers/src/main/docs/");
                    docFiles = docFolder.listFiles(new ComponentDocFilter(componentName));
                } else {
                    componentName = name.substring(6, name.length() - 8);
                    this.getLog().debug((CharSequence)("Camel component: " + componentName));
                    docFolder = new File(compDir, "camel-" + componentName + "/src/main/docs/");
                    docFiles = docFolder.listFiles(new ComponentDocFilter(componentName));
                    if (docFiles == null || docFiles.length == 0) {
                        docFolder = new File(compDir, "camel-" + componentName + "/camel-" + componentName + "-component/src/main/docs/");
                        docFiles = docFolder.listFiles(new ComponentDocFilter(componentName));
                    }
                }
                if (docFiles != null && docFiles.length > 0) {
                    List<File> files = Arrays.asList(docFiles);
                    boolean hasComponentDataFormatOrLanguage = files.stream().anyMatch(f -> f.getName().endsWith("-component.adoc") || f.getName().endsWith("-dataformat.adoc") || f.getName().endsWith("-language.adoc"));
                    if (hasComponentDataFormatOrLanguage) {
                        files = Arrays.stream(docFiles).filter(f -> !f.getName().equals(componentName + ".adoc")).collect(Collectors.toList());
                    }
                    if (files.size() == 1) {
                        boolean onlyOther;
                        List<SpringBootAutoConfigureOptionModel> models = this.parseSpringBootAutoConfigureModels(jsonFile, null);
                        boolean bl = onlyOther = files.size() == 1 && !hasComponentDataFormatOrLanguage;
                        if (models.isEmpty() && onlyOther) {
                            return;
                        }
                        File docFile = files.get(0);
                        boolean noDescription = false;
                        for (SpringBootAutoConfigureOptionModel o : models) {
                            if (!StringHelper.isEmpty(o.getDescription())) continue;
                            noDescription = true;
                            this.getLog().warn((CharSequence)("Option " + o.getName() + " has no description"));
                        }
                        if (noDescription && this.isFailOnNoDescription()) {
                            throw new MojoExecutionException("Failed build due failOnMissingDescription=true");
                        }
                        String options = this.templateAutoConfigurationOptions(models);
                        boolean updated = this.updateAutoConfigureOptions(docFile, options);
                        if (updated) {
                            this.getLog().info((CharSequence)("Updated doc file: " + docFile));
                        } else {
                            this.getLog().debug((CharSequence)("No changes to doc file: " + docFile));
                        }
                    } else if (files.size() > 1) {
                        for (File docFile : files) {
                            String docName = docFile.getName();
                            int pos = docName.lastIndexOf("-");
                            String prefix = pos > 0 ? docName.substring(0, pos).toLowerCase(Locale.US) : null;
                            List<SpringBootAutoConfigureOptionModel> models = this.parseSpringBootAutoConfigureModels(jsonFile, prefix);
                            boolean noDescription = false;
                            for (SpringBootAutoConfigureOptionModel o : models) {
                                if (!StringHelper.isEmpty(o.getDescription())) continue;
                                noDescription = true;
                                this.getLog().warn((CharSequence)("Option " + o.getName() + " has no description"));
                            }
                            if (noDescription && this.isFailOnNoDescription()) {
                                throw new MojoExecutionException("Failed build due failOnMissingDescription=true");
                            }
                            String options = this.templateAutoConfigurationOptions(models);
                            boolean updated = this.updateAutoConfigureOptions(docFile, options);
                            if (updated) {
                                this.getLog().info((CharSequence)("Updated doc file: " + docFile));
                                continue;
                            }
                            this.getLog().debug((CharSequence)("No changes to doc file: " + docFile));
                        }
                    }
                } else {
                    this.getLog().warn((CharSequence)("No component docs found in folder: " + docFolder));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
            }
        }
    }

    private File getComponentsDir(String name) {
        if ("camel-spring-boot".equals(name)) {
            return this.project.getBasedir();
        }
        return this.componentsDir;
    }

    private static String asComponentName(String componentName) {
        if ("fastjson".equals(componentName)) {
            return "json-fastjson";
        }
        if ("gson".equals(componentName)) {
            return "json-gson";
        }
        if ("jackson".equals(componentName)) {
            return "json-jackson";
        }
        if ("johnzon".equals(componentName)) {
            return "json-johnzon";
        }
        if ("snakeyaml".equals(componentName)) {
            return "yaml-snakeyaml";
        }
        if ("cassandraql".equals(componentName)) {
            return "cql";
        }
        if ("josql".equals(componentName)) {
            return "sql";
        }
        if ("jetty9".equals(componentName)) {
            return "jetty";
        }
        if ("juel".equals(componentName)) {
            return "el";
        }
        if ("jsch".equals(componentName)) {
            return "scp";
        }
        if ("printer".equals(componentName)) {
            return "lpr";
        }
        if ("saxon".equals(componentName)) {
            return "xquery";
        }
        if ("script".equals(componentName)) {
            return "javaScript";
        }
        if ("stringtemplate".equals(componentName)) {
            return "string-template";
        }
        if ("tagsoup".equals(componentName)) {
            return "tidyMarkup";
        }
        if ("xmlbeans".equals(componentName)) {
            return "xmlBeans";
        }
        return componentName;
    }

    private static boolean isValidStarter(String name) {
        return !"camel-core-starter".equals(name);
    }

    private List<SpringBootAutoConfigureOptionModel> parseSpringBootAutoConfigureModels(File file, String include) throws IOException, DeserializationException {
        this.getLog().debug((CharSequence)("Parsing Spring Boot AutoConfigureModel using include: " + include));
        ArrayList<SpringBootAutoConfigureOptionModel> answer = new ArrayList<SpringBootAutoConfigureOptionModel>();
        JsonObject obj = (JsonObject)Jsoner.deserialize((Reader)new FileReader(file));
        JsonArray arr = (JsonArray)obj.getCollection("properties");
        if (arr != null && !arr.isEmpty()) {
            arr.forEach(e -> {
                boolean skip;
                JsonObject row = (JsonObject)e;
                String name = row.getString("name");
                String javaType = row.getString("type");
                String desc = row.getStringOrDefault("description", "");
                String defaultValue = row.getStringOrDefault("defaultValue", "");
                boolean bl = skip = name.endsWith("customizer.enabled") || include != null && !name.contains("." + include + ".");
                if (!skip) {
                    SpringBootAutoConfigureOptionModel model = new SpringBootAutoConfigureOptionModel();
                    model.setName(name);
                    model.setJavaType(javaType);
                    model.setDefaultValue(defaultValue);
                    model.setDescription(desc);
                    answer.add(model);
                }
            });
        }
        return answer;
    }

    private boolean updateAutoConfigureOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// spring-boot-auto-configure options: START", "// spring-boot-auto-configure options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// spring-boot-auto-configure options: START");
                String after = StringHelper.after(text, "// spring-boot-auto-configure options: END");
                text = before + "// spring-boot-auto-configure options: START\n" + changed + "\n// spring-boot-auto-configure options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// spring-boot-auto-configure options: START");
            this.getLog().warn((CharSequence)"\t// spring-boot-auto-configure options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private String templateAutoConfigurationOptions(List<SpringBootAutoConfigureOptionModel> options) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateSpringBootAutoConfigurationReadmeMojo.class.getClassLoader().getResourceAsStream("spring-boot-auto-configure-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, options);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }

    private boolean isFailOnNoDescription() {
        return this.failOnMissingDescription != null && this.failOnMissingDescription != false;
    }

    private static final class ComponentDocFilter
    implements FileFilter {
        private final String componentName;

        public ComponentDocFilter(String componentName) {
            this.componentName = UpdateSpringBootAutoConfigurationReadmeMojo.asComponentName(componentName);
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return name.startsWith(this.componentName) && name.endsWith(".adoc");
        }
    }
}

