/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.DataFormatOptionModel;

public class DataFormatModel {
    private final boolean coreOnly;
    private String kind;
    private String name;
    private String modelName;
    private String title;
    private String description;
    private String firstVersion;
    private String label;
    private String deprecated;
    private String deprecationNote;
    private String javaType;
    private String groupId;
    private String artifactId;
    private String version;
    private final List<DataFormatOptionModel> dataFormatOptions = new ArrayList<DataFormatOptionModel>();

    public DataFormatModel() {
        this(false);
    }

    public DataFormatModel(boolean coreOnly) {
        this.coreOnly = coreOnly;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFirstVersion() {
        return this.firstVersion;
    }

    public void setFirstVersion(String firstVersion) {
        this.firstVersion = firstVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public void setDeprecationNote(String deprecationNote) {
        this.deprecationNote = deprecationNote;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<DataFormatOptionModel> getDataFormatOptions() {
        return this.dataFormatOptions;
    }

    public void addDataFormatOption(DataFormatOptionModel option) {
        this.dataFormatOptions.add(option);
    }

    public String getShortJavaType() {
        return StringHelper.getClassShortName(this.javaType);
    }

    public String getDocLink() {
        if ("camel-fhir".equals(this.artifactId)) {
            return "camel-fhir/camel-fhir-component/src/main/docs";
        }
        if ("camel-core".equals(this.artifactId)) {
            return this.coreOnly ? "src/main/docs" : "../camel-core/src/main/docs";
        }
        return this.artifactId + "/src/main/docs";
    }

    public String getFirstVersionShort() {
        return StringHelper.cutLastZeroDigit(this.firstVersion);
    }
}

