/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.maven.resources.Resource;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;

@Mojo(name="copy-resources", threadSafe=true)
public class CopyResources
extends AbstractMojo {
    public static final List<String> NON_FILTERED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("jpg", "jpeg", "gif", "bmp", "png"));
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter
    private String encoding = "UTF-8";
    @Parameter(required=true)
    private File outputDirectory;
    @Parameter(required=true)
    private List<Resource> resources;
    @Component
    private MavenSession session;
    @Component
    private MavenReaderFilter readerFilter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path output = this.outputDirectory.toPath();
            char[] buf = new char[8192];
            StringBuilder sb = new StringBuilder(8192);
            for (Resource resource : this.resources) {
                Path dir = resource.getDirectory().toPath();
                List files = Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path file : files) {
                    boolean filtering = this.isFiltering(resource, file);
                    if (filtering) {
                        try {
                            BufferedReader reader = Files.newBufferedReader(file, Charset.forName(this.encoding));
                            Throwable throwable = null;
                            try {
                                int l;
                                Reader wrapped = this.readerFilter.filter((Reader)reader, true, this.project, null, false, this.session);
                                sb.setLength(0);
                                while ((l = wrapped.read(buf, 0, buf.length)) >= 0) {
                                    sb.append(buf, 0, l);
                                }
                                String content = sb.toString();
                                FileUtil.updateFile((Path)output.resolve(dir.relativize(file)), (String)content);
                                continue;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                                continue;
                            }
                        }
                        catch (IOException e) {
                            throw new IOException("Error processing resource: " + file, e);
                        }
                    }
                    FileUtil.updateFile((Path)file, (Path)output.resolve(dir.relativize(file)));
                }
            }
        }
        catch (IOException | MavenFilteringException e) {
            throw new MojoFailureException("Unable to copy resources", e);
        }
    }

    protected boolean isFiltering(Resource resource, Path file) {
        if (resource.isFiltering()) {
            String ext = Strings.after((String)file.getFileName().toString(), (String)".");
            return ext == null || !NON_FILTERED_EXTENSIONS.contains(ext);
        }
        return false;
    }
}

