/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.restlet.DefaultRestletHost;
import org.apache.camel.component.restlet.MethodBasedRouter;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletHost;
import org.apache.camel.component.restlet.RestletHostOptions;
import org.apache.camel.component.restlet.converter.RestletConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.engine.Engine;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory,
SSLContextParametersAware,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(RestletComponent.class);
    private static final Object LOCK = new Object();
    private final Map<String, RestletHost> restletHostRegistry = new HashMap<String, RestletHost>();
    private final Map<String, MethodBasedRouter> routers = new HashMap<String, MethodBasedRouter>();
    private final Component component;
    @Metadata(label="consumer,advanced")
    private Boolean controllerDaemon;
    @Metadata(label="consumer,advanced")
    private Integer controllerSleepTimeMs;
    @Metadata(label="consumer")
    private Integer inboundBufferSize;
    @Metadata(label="consumer,advanced")
    private Integer minThreads;
    @Metadata(label="consumer,advanced")
    private Integer maxThreads;
    @Metadata(label="consumer,advanced")
    private Integer lowThreads;
    @Metadata(label="common")
    private Integer maxConnectionsPerHost;
    @Metadata(label="common")
    private Integer maxTotalConnections;
    @Metadata(label="consumer")
    private Integer outboundBufferSize;
    @Metadata(label="consumer,advanced")
    private Integer maxQueued;
    @Metadata(label="consumer,advanced")
    private Boolean persistingConnections;
    @Metadata(label="consumer,advanced")
    private Boolean pipeliningConnections;
    @Metadata(label="consumer,advanced")
    private Integer threadMaxIdleTimeMs;
    @Metadata(label="consumer")
    private Boolean useForwardedForHeader;
    @Metadata(label="consumer")
    private Boolean reuseAddress;
    @Metadata(label="consumer,advanced")
    private boolean disableStreamCache;
    @Metadata(label="consumer")
    private int port;
    @Metadata(label="producer")
    private Boolean synchronous;
    @Metadata(label="advanced")
    private List<String> enabledConverters;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="filter", description="To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;

    public RestletComponent() {
        this(new Component());
    }

    public RestletComponent(Component component) {
        this.component = component;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String endpointUri = uri;
        if (endpointUri.indexOf(63) > 0) {
            endpointUri = endpointUri.substring(0, endpointUri.indexOf(63));
        }
        endpointUri = URISupport.normalizeUri((String)endpointUri);
        endpointUri = endpointUri.replaceAll("%7B", "{").replaceAll("%7D", "}");
        String restletMethods = (String)this.getAndRemoveParameter(parameters, "restletMethods", String.class);
        if (restletMethods != null) {
            endpointUri = endpointUri + "?restletMethods=" + restletMethods.toUpperCase();
        }
        String restletMethod = null;
        if (restletMethods == null) {
            restletMethod = (String)this.getAndRemoveParameter(parameters, "restletMethod", String.class, "GET");
            endpointUri = endpointUri + "?restletMethod=" + restletMethod.toUpperCase();
        }
        RestletEndpoint result = new RestletEndpoint(this, endpointUri);
        if (this.synchronous != null) {
            result.setSynchronous(this.synchronous);
        }
        result.setDisableStreamCache(this.isDisableStreamCache());
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Object)result, parameters);
        if (restletMethods != null) {
            result.setRestletMethods(RestletConverter.toMethods(restletMethods));
        } else {
            result.setRestletMethod(RestletConverter.toMethod(restletMethod));
        }
        String remainingRaw = URISupport.extractRemainderPath((URI)new URI(uri), (boolean)true);
        URI u = new URI(remainingRaw);
        String protocol = u.getScheme();
        String uriPattern = URISupport.createRemainingURI((URI)u, parameters).getRawPath();
        uriPattern = uriPattern.replaceAll("%7B", "{").replaceAll("%7D", "}");
        String host = u.getHost();
        int port = u.getPort() > 0 ? u.getPort() : this.port;
        result.setProtocol(protocol);
        result.setUriPattern(uriPattern);
        result.setHost(host);
        if (port > 0) {
            result.setPort(port);
        }
        if (result.getSslContextParameters() == null) {
            result.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        if (!parameters.isEmpty()) {
            result.setQueryParameters(parameters);
            endpointUri = URISupport.appendParametersToURI((String)endpointUri, parameters);
            result.setCompleteEndpointUri(endpointUri);
        }
        return result;
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("restlet", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
        RestletComponent.cleanupConverters(this.enabledConverters);
        this.component.start();
    }

    protected void doStop() throws Exception {
        this.component.stop();
        this.restletHostRegistry.clear();
        super.doStop();
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public void connect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = consumer.getEndpoint();
        this.addServerIfNecessary(endpoint);
        String offsetPath = (String)this.component.getContext().getAttributes().get("org.restlet.ext.servlet.offsetPath");
        if (endpoint.getUriPattern() != null && endpoint.getUriPattern().length() > 0) {
            this.attachUriPatternToRestlet(offsetPath, endpoint.getUriPattern(), endpoint, consumer.getRestlet());
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                this.attachUriPatternToRestlet(offsetPath, uriPattern, endpoint, consumer.getRestlet());
            }
        }
    }

    public void disconnect(RestletConsumer consumer) throws Exception {
        MethodBasedRouter methodRouter;
        RestletEndpoint endpoint = consumer.getEndpoint();
        ArrayList<MethodBasedRouter> routesToRemove = new ArrayList<MethodBasedRouter>();
        String pattern = endpoint.getUriPattern();
        if (pattern != null && !pattern.isEmpty() && (methodRouter = this.getMethodRouter(pattern, false)) != null) {
            routesToRemove.add(methodRouter);
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                MethodBasedRouter methodRouter2 = this.getMethodRouter(uriPattern, false);
                if (methodRouter2 == null) continue;
                routesToRemove.add(methodRouter2);
            }
        }
        for (MethodBasedRouter router : routesToRemove) {
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, Method.OPTIONS);
            if (endpoint.getRestletMethods() != null) {
                Collections.addAll(methods, endpoint.getRestletMethods());
            } else {
                Collections.addAll(methods, endpoint.getRestletMethod());
            }
            for (Method method : methods) {
                router.removeRoute(method);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detached restlet uriPattern: {} method: {}", (Object)router.getUriPattern(), (Object)endpoint.getRestletMethod());
            }
            if (router.hasRoutes()) continue;
            this.deAttachUriPatternFromRestlet(router.getUriPattern(), endpoint, router);
            if (!router.isStopped()) {
                router.stop();
            }
            this.routers.remove(router.getUriPattern());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBasedRouter getMethodRouter(String uriPattern, boolean addIfEmpty) {
        Map<String, MethodBasedRouter> map = this.routers;
        synchronized (map) {
            MethodBasedRouter result = this.routers.get(uriPattern);
            if (result == null && addIfEmpty) {
                result = new MethodBasedRouter(uriPattern);
                LOG.debug("Added method based router: {}", (Object)result);
                this.routers.put(uriPattern, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServerIfNecessary(RestletEndpoint endpoint) throws Exception {
        String key = RestletComponent.buildKey(endpoint);
        Map<String, RestletHost> map = this.restletHostRegistry;
        synchronized (map) {
            RestletHost host = this.restletHostRegistry.get(key);
            if (host == null) {
                host = this.createRestletHost();
                host.configure(endpoint, this.component);
                this.restletHostRegistry.put(key, host);
                LOG.debug("Added host: {}", (Object)key);
                host.start();
            }
        }
    }

    protected RestletHost createRestletHost() {
        RestletHostOptions options = new RestletHostOptions();
        if (this.getControllerDaemon() != null) {
            options.setControllerDaemon(this.getControllerDaemon());
        }
        if (this.getControllerSleepTimeMs() != null) {
            options.setControllerSleepTimeMs(this.getControllerSleepTimeMs());
        }
        if (this.getInboundBufferSize() != null) {
            options.setInboundBufferSize(this.getInboundBufferSize());
        }
        if (this.getMinThreads() != null) {
            options.setMinThreads(this.getMinThreads());
        }
        if (this.getMaxThreads() != null) {
            options.setMaxThreads(this.getMaxThreads());
        }
        if (this.getLowThreads() != null) {
            options.setLowThreads(this.getLowThreads());
        }
        if (this.getMaxQueued() != null) {
            options.setMaxQueued(this.getMaxQueued());
        }
        if (this.getMaxConnectionsPerHost() != null) {
            options.setMaxConnectionsPerHost(this.getMaxConnectionsPerHost());
        }
        if (this.getMaxTotalConnections() != null) {
            options.setMaxTotalConnections(this.getMaxTotalConnections());
        }
        if (this.getOutboundBufferSize() != null) {
            options.setOutboundBufferSize(this.getOutboundBufferSize());
        }
        if (this.getPersistingConnections() != null) {
            options.setPersistingConnections(this.getPersistingConnections());
        }
        if (this.getPipeliningConnections() != null) {
            options.setPipeliningConnections(this.getPipeliningConnections());
        }
        if (this.getThreadMaxIdleTimeMs() != null) {
            options.setThreadMaxIdleTimeMs(this.getThreadMaxIdleTimeMs());
        }
        if (this.getUseForwardedForHeader() != null) {
            options.setUseForwardedForHeader(this.getUseForwardedForHeader());
        }
        if (this.getReuseAddress() != null) {
            options.setReuseAddress(this.getReuseAddress());
        }
        return new DefaultRestletHost(options);
    }

    private static String buildKey(RestletEndpoint endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void attachUriPatternToRestlet(String offsetPath, String uriPattern, RestletEndpoint endpoint, Restlet target) throws Exception {
        MethodBasedRouter router = this.getMethodRouter(uriPattern, true);
        Map<String, String> realm = endpoint.getRestletRealm();
        if (realm != null && realm.size() > 0) {
            ChallengeAuthenticator guard = new ChallengeAuthenticator(this.component.getContext().createChildContext(), ChallengeScheme.HTTP_BASIC, "Camel-Restlet Endpoint Realm");
            MapVerifier verifier = new MapVerifier();
            for (Map.Entry<String, String> entry : realm.entrySet()) {
                verifier.getLocalSecrets().put(entry.getKey(), entry.getValue().toCharArray());
            }
            guard.setVerifier((Verifier)verifier);
            guard.setNext(target);
            target = guard;
            LOG.debug("Target has been set to guard: {}", (Object)guard);
        }
        ArrayList methods = new ArrayList();
        Collections.addAll(methods, Method.OPTIONS);
        if (endpoint.getRestletMethods() != null) {
            Collections.addAll(methods, endpoint.getRestletMethods());
        } else {
            Collections.addAll(methods, endpoint.getRestletMethod());
        }
        for (Method method : methods) {
            router.addRoute(method, target);
            LOG.debug("Attached restlet uriPattern: {} method: {}", (Object)uriPattern, (Object)method);
        }
        if (!router.hasBeenAttached()) {
            this.component.getDefaultHost().attach(offsetPath == null ? uriPattern : offsetPath + uriPattern, (Restlet)router);
            LOG.debug("Attached methodRouter uriPattern: {}", (Object)uriPattern);
        }
        if (!router.isStarted()) {
            router.start();
            LOG.debug("Started methodRouter uriPattern: {}", (Object)uriPattern);
        }
    }

    private void deAttachUriPatternFromRestlet(String uriPattern, RestletEndpoint endpoint, Restlet target) throws Exception {
        this.component.getDefaultHost().detach(target);
        LOG.debug("De-attached methodRouter uriPattern: {}", (Object)uriPattern);
    }

    public Boolean getControllerDaemon() {
        return this.controllerDaemon;
    }

    public void setControllerDaemon(Boolean controllerDaemon) {
        this.controllerDaemon = controllerDaemon;
    }

    public Integer getControllerSleepTimeMs() {
        return this.controllerSleepTimeMs;
    }

    public void setControllerSleepTimeMs(Integer controllerSleepTimeMs) {
        this.controllerSleepTimeMs = controllerSleepTimeMs;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Integer getInboundBufferSize() {
        return this.inboundBufferSize;
    }

    public void setInboundBufferSize(Integer inboundBufferSize) {
        this.inboundBufferSize = inboundBufferSize;
    }

    public Integer getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getLowThreads() {
        return this.lowThreads;
    }

    public void setLowThreads(Integer lowThreads) {
        this.lowThreads = lowThreads;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getOutboundBufferSize() {
        return this.outboundBufferSize;
    }

    public void setOutboundBufferSize(Integer outboundBufferSize) {
        this.outboundBufferSize = outboundBufferSize;
    }

    public Boolean getPersistingConnections() {
        return this.persistingConnections;
    }

    public void setPersistingConnections(Boolean persistingConnections) {
        this.persistingConnections = persistingConnections;
    }

    public Boolean getPipeliningConnections() {
        return this.pipeliningConnections;
    }

    public void setPipeliningConnections(Boolean pipeliningConnections) {
        this.pipeliningConnections = pipeliningConnections;
    }

    public Integer getThreadMaxIdleTimeMs() {
        return this.threadMaxIdleTimeMs;
    }

    public void setThreadMaxIdleTimeMs(Integer threadMaxIdleTimeMs) {
        this.threadMaxIdleTimeMs = threadMaxIdleTimeMs;
    }

    public Boolean getUseForwardedForHeader() {
        return this.useForwardedForHeader;
    }

    public void setUseForwardedForHeader(Boolean useForwardedForHeader) {
        this.useForwardedForHeader = useForwardedForHeader;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public Integer getMaxQueued() {
        return this.maxQueued;
    }

    public void setMaxQueued(Integer maxQueued) {
        this.maxQueued = maxQueued;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disableStreamCache) {
        this.disableStreamCache = disableStreamCache;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public List<String> getEnabledConverters() {
        return this.enabledConverters;
    }

    public void setEnabledConverters(List<String> enabledConverters) {
        if (enabledConverters != null && !enabledConverters.isEmpty()) {
            this.enabledConverters = new ArrayList<String>(enabledConverters);
        }
    }

    public void setEnabledConverters(String enabledConverters) {
        if (ObjectHelper.isNotEmpty((Object)enabledConverters)) {
            this.enabledConverters = Arrays.asList(enabledConverters.split(","));
        }
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String url;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = this.getPort();
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration("restlet", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("restlet")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        boolean cors = config.isEnableCORS();
        String query = URISupport.createQueryString(map);
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        if (port > 0) {
            url = "restlet:%s://%s:%s/%s?restletMethods=%s";
            url = String.format(url, scheme, host, port, path, restrict);
        } else {
            url = "restlet:/%s?restletMethods=%s";
            url = String.format(url, path, restrict);
        }
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        RestletEndpoint endpoint = (RestletEndpoint)camelContext.getEndpoint(url, RestletEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        ServiceHelper.startService((Service)endpoint);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.createConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters);
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        RestConfiguration config;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String restletMethod = verb.toUpperCase(Locale.US);
        String url = "restlet:" + host;
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        if ((config = configuration) == null) {
            config = camelContext.getRestConfiguration("restlet", true);
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("restlet")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        url = !(query = URISupport.createQueryString(map)).isEmpty() ? url + "?" + query : url + "?restletMethod=" + restletMethod;
        RestletEndpoint endpoint = (RestletEndpoint)camelContext.getEndpoint(url, RestletEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanupConverters(List<String> converters) {
        if (converters != null && !converters.isEmpty()) {
            Object object = LOCK;
            synchronized (object) {
                Engine.getInstance().getRegisteredConverters().removeIf(converter -> !converters.contains(converter.getClass().getName()) && !converters.contains(converter.getClass().getSimpleName()));
            }
        }
    }

    public void setEndpointHeaderFilterStrategy(Endpoint endpoint) {
        if (this.headerFilterStrategy != null && endpoint instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)endpoint).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }
}

