/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.CastUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregateRssFeedStrategy
implements AggregationStrategy {
    protected final transient Log log = LogFactory.getLog(AggregateRssFeedStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        SyndFeed oldFeed = (SyndFeed)oldExchange.getIn().getBody(SyndFeed.class);
        SyndFeed newFeed = (SyndFeed)newExchange.getIn().getBody(SyndFeed.class);
        if (oldFeed != null && newFeed != null) {
            List oldEntries = CastUtils.cast((List)oldFeed.getEntries());
            List newEntries = CastUtils.cast((List)newFeed.getEntries());
            ArrayList mergedList = new ArrayList(oldEntries.size() + newEntries.size());
            mergedList.addAll(oldEntries);
            mergedList.addAll(newEntries);
            oldFeed.setEntries(mergedList);
        } else {
            this.log.debug((Object)"Could not merge exchanges. One body was null.");
        }
        return oldExchange;
    }
}

