/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.rss.RssEndpoint;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssComponent
extends FeedComponent {
    protected FeedEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new RssEndpoint(uri, this, null);
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        String feedUri;
        RssEndpoint rss = (RssEndpoint)endpoint;
        if (rss.getFeedUri() != null) {
            return;
        }
        if (!parameters.isEmpty()) {
            URI remainingUri = URISupport.createRemainingURI((URI)new URI(remaining), (Map)CastUtils.cast(parameters));
            feedUri = remainingUri.toString();
        } else {
            feedUri = remaining;
        }
        rss.setFeedUri(feedUri);
    }
}

