/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import java.util.Date;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatedDateFilter
implements EntryFilter {
    private static final transient Log LOG = LogFactory.getLog(UpdatedDateFilter.class);
    private Date lastUpdate;

    public UpdatedDateFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isValidEntry(FeedEndpoint endpoint, Object feed, Object entry) {
        Date updated = ((SyndEntry)entry).getUpdatedDate();
        if (updated == null) {
            updated = ((SyndEntry)entry).getPublishedDate();
        }
        if (updated == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No updated time for entry so assuming its valid: entry=[" + entry + "]"));
            }
            return true;
        }
        if (this.lastUpdate != null && (this.lastUpdate.after(updated) || this.lastUpdate.equals(updated))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Entry is older than lastupdate=[" + this.lastUpdate + "], no valid entry=[" + entry + "]"));
            }
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }
}

