/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelException;

public class ServiceNowException
extends CamelException {
    private final Integer code;
    private final String status;
    private final String detail;
    private final Map<Object, Object> attributes;

    public ServiceNowException(Integer code, String status, String message, String detail) {
        super(message);
        this.code = code;
        this.status = status;
        this.detail = detail;
        this.attributes = Collections.emptyMap();
    }

    public ServiceNowException(Integer code, Map<Object, Object> attributes) {
        super(String.format("Status (%d)", code));
        this.code = code;
        this.status = null;
        this.detail = null;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getMessage() != null ? "" + this.status + ": " + this.getMessage() : super.toString();
    }
}

