/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.fuji;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.releases.fuji.FujiServiceNowProcessor;
import org.apache.camel.util.ObjectHelper;

class FujiServiceNowImportSetProcessor
extends FujiServiceNowProcessor {
    FujiServiceNowImportSetProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> requestModel, Class<?> responseModel, String action, String apiVersion, String tableName, String sysId) throws Exception {
        Response response;
        if (ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            response = this.retrieveRecord(exchange.getIn(), requestModel, responseModel, apiVersion, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"create", (Object)action, (boolean)true)) {
            response = this.createRecord(exchange.getIn(), requestModel, responseModel, apiVersion, tableName);
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private Response retrieveRecord(Message in, Class<?> requestModel, Class<?> responseModel, String apiVersion, String tableName, String sysId) throws Exception {
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(tableName).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(responseModel).invoke("GET");
    }

    private Response createRecord(Message in, Class<?> requestModel, Class<?> responseModel, String apiVersion, String tableName) throws Exception {
        if (((Boolean)in.getHeader("CamelServiceNowRetrieveTargetRecord", this.config::getRetrieveTargetRecordOnImport, Boolean.class)).booleanValue()) {
            throw new UnsupportedOperationException("RetrieveTargetRecordOnImport is supported from Helsinky");
        }
        this.validateBody(in, requestModel);
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(tableName).query(responseModel).invoke("POST", in.getMandatoryBody());
    }
}

